/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers.impl;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.osgi.util.converter.ConversionException;
import org.osgi.util.converter.Converter;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.TargetRule;
import org.osgi.util.converter.TypeRule;

public final class ObjectConverter {
    private static Converter converter;

    private ObjectConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Converter getConverter() {
        if (converter != null) return converter;
        Class<ObjectConverter> clazz = ObjectConverter.class;
        synchronized (ObjectConverter.class) {
            if (converter != null) return converter;
            converter = Converters.newConverterBuilder().rule((TargetRule)new TypeRule(String.class, Calendar.class, ObjectConverter::toCalendar)).rule((TargetRule)new TypeRule(Date.class, Calendar.class, ObjectConverter::toCalendar)).rule((TargetRule)new TypeRule(String.class, Date.class, ObjectConverter::toDate)).rule((TargetRule)new TypeRule(Calendar.class, String.class, ObjectConverter::toString)).rule((TargetRule)new TypeRule(Date.class, String.class, ObjectConverter::toString)).rule((TargetRule)new TypeRule(Calendar.class, Date.class, ObjectConverter::toDate)).rule((TargetRule)new TypeRule(Calendar.class, ZonedDateTime.class, ObjectConverter::toZonedDateTime)).rule((TargetRule)new TypeRule(ZonedDateTime.class, Calendar.class, ObjectConverter::toCalendar)).rule((TargetRule)new TypeRule(ZonedDateTime.class, String.class, ObjectConverter::toString)).build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return converter;
        }
    }

    private static String toString(ZonedDateTime zonedDateTime) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zonedDateTime);
    }

    private static Calendar toCalendar(ZonedDateTime zonedDateTime) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(zonedDateTime.getOffset()));
        calendar.setTimeInMillis(zonedDateTime.toInstant().toEpochMilli());
        return calendar;
    }

    private static ZonedDateTime toZonedDateTime(Calendar calendar) {
        return ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId().normalized());
    }

    private static String toString(Calendar cal) {
        return cal.toInstant().toString();
    }

    private static String toString(Date cal) {
        return cal.toInstant().toString();
    }

    private static Calendar toCalendar(String date) {
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(date, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        return ObjectConverter.toCalendar(zonedDateTime);
    }

    private static Calendar toCalendar(Date date) {
        Calendar response = Calendar.getInstance();
        response.setTime(date);
        return response;
    }

    private static Date toDate(String date) {
        return Date.from(Instant.parse(date));
    }

    private static Date toDate(Calendar cal) {
        return cal.getTime();
    }

    public static <T> T convert(Object obj, Class<T> type) {
        if (obj == null) {
            return null;
        }
        try {
            return (T)ObjectConverter.getConverter().convert(obj).to(type);
        }
        catch (ConversionException ce) {
            return null;
        }
    }
}

