/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import java.util.HashMap;
import java.util.HashSet;
import org.xml.sax.Attributes;

public class OsgiAppenderRefInternalAction
extends Action {
    static String OSGI_APPENDER_REF_BAG = "OSGI_APPENDER_BAG";
    boolean inError = false;

    public void begin(InterpretationContext ec, String tagName, Attributes attributes) throws ActionException {
        HashSet<String> loggers;
        this.inError = false;
        Object o = ec.peekObject();
        if (!(o instanceof Logger)) {
            String errMsg = "Could not find an Logger at the top of execution stack. Near [" + tagName + "] line " + this.getLineNumber(ec);
            this.inError = true;
            this.addError(errMsg);
            return;
        }
        Logger logger = (Logger)o;
        String appenderName = ec.subst(attributes.getValue("ref"));
        if (OptionHelper.isEmpty((String)appenderName)) {
            String errMsg = "Missing appender ref attribute in <appender-ref> tag.";
            this.inError = true;
            this.addError(errMsg);
            return;
        }
        HashMap<String, HashSet<String>> appenderBag = (HashMap<String, HashSet<String>>)ec.getObjectMap().get(OSGI_APPENDER_REF_BAG);
        if (appenderBag == null) {
            appenderBag = new HashMap<String, HashSet<String>>();
            ec.getObjectMap().put(OSGI_APPENDER_REF_BAG, appenderBag);
        }
        if ((loggers = (HashSet<String>)appenderBag.get(appenderName)) == null) {
            loggers = new HashSet<String>();
            appenderBag.put(appenderName, loggers);
        }
        loggers.add(logger.getName());
    }

    public void end(InterpretationContext ic, String name) throws ActionException {
    }
}

