/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HealthCheck.class}, property={"service.vendor=The Apache Software Foundation", "hc.name=Scheduler Health Check", "hc.mbean.name=slingCommonsSchedulerHealthCheck"})
@Designate(ocd=Config.class)
public class SchedulerHealthCheck
implements HealthCheck {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private MetricRegistry metricRegistry;
    private static final long DEFAULT_MAX_QUARTZJOB_DURATION_ACCEPTABLE = 60000L;
    private long maxQuartzJobDurationAcceptable;

    @Activate
    protected void activate(Config config) {
        this.configure(config);
    }

    @Modified
    protected void modified(Config config) {
        this.configure(config);
    }

    protected void configure(Config config) {
        this.maxQuartzJobDurationAcceptable = config.max_quartzJob_duration_acceptable();
    }

    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        try {
            SortedMap oldestGaugeSet;
            long runningCount = 0L;
            SortedMap runningCntSet = this.metricRegistry.getCounters(new MetricFilter(){

                public boolean matches(String name, Metric metric) {
                    return name.equals("commons.scheduler.running.jobs");
                }
            });
            if (runningCntSet != null) {
                Iterator it = runningCntSet.values().iterator();
                if (it.hasNext()) {
                    runningCount = ((Counter)it.next()).getCount();
                }
                runningCount = Math.max(0L, runningCount);
            }
            if ((oldestGaugeSet = this.metricRegistry.getGauges(new MetricFilter(){

                public boolean matches(String name, Metric metric) {
                    return name.equals("commons.scheduler.oldest.running.job.millis");
                }
            })).isEmpty()) {
                resultLog.warn("Sling Scheduler cannot find any metrics gauge starting with {}", new Object[]{"commons.scheduler.oldest.running.job.millis"});
            } else {
                long oldestRunningJobInMillis = (Long)((Gauge)oldestGaugeSet.values().iterator().next()).getValue();
                if (oldestRunningJobInMillis <= -1L) {
                    resultLog.info("Sling Scheduler has no long-running Quartz-Jobs at this moment.", new Object[0]);
                } else if (oldestRunningJobInMillis > this.maxQuartzJobDurationAcceptable) {
                    String slowPrefix = "commons.scheduler.oldest.running.job.millis.slow.";
                    MetricFilter filter = new MetricFilter(){

                        public boolean matches(String name, Metric metric) {
                            return name.startsWith("commons.scheduler.oldest.running.job.millis.slow.");
                        }
                    };
                    SortedMap allGaugeSet = this.metricRegistry.getGauges(filter);
                    if (allGaugeSet.isEmpty()) {
                        resultLog.critical("Sling Scheduler has at least one long-running Quartz-Job with the oldest running for {}ms.", new Object[]{oldestRunningJobInMillis});
                    } else {
                        StringBuffer slowNames = new StringBuffer();
                        Iterator it = allGaugeSet.entrySet().iterator();
                        int numSlow = 0;
                        while (it.hasNext()) {
                            Map.Entry e = it.next();
                            Gauge slowGauge = (Gauge)e.getValue();
                            long millis = (Long)slowGauge.getValue();
                            if (millis < 0L) continue;
                            if (numSlow++ > 0) {
                                slowNames.append(", ");
                            }
                            slowNames.append(((String)e.getKey()).substring("commons.scheduler.oldest.running.job.millis.slow.".length()));
                            slowNames.append("=").append(millis).append("ms");
                        }
                        if (numSlow == 1) {
                            resultLog.critical("Sling Scheduler has 1 long-running Quartz-Job which is already running for {}ms: {}.", new Object[]{oldestRunningJobInMillis, slowNames});
                        } else {
                            resultLog.critical("Sling Scheduler has {} long-running Quartz-Jobs with the oldest running for {}ms: {}.", new Object[]{numSlow, oldestRunningJobInMillis, slowNames});
                        }
                    }
                    resultLog.info("More details are exposed in metrics including gauges for slow Quartz-Jobs containing shortened job names.", new Object[0]);
                    resultLog.info("Furthermore, thread-dumps can also help narrow down slow Quartz-Jobs.", new Object[0]);
                } else {
                    resultLog.info("Sling Scheduler has no long-running Quartz-Jobs at this moment, the oldest current Quartz-Job is {}ms.", new Object[]{oldestRunningJobInMillis});
                }
                resultLog.info("The total number of currently runnning Quartz-Jobs is {}.", new Object[]{runningCount});
                resultLog.info("[The maximum acceptable duration a Quartz-Job should run for is configured to {}ms. This duration can be changed in the QuartzScheduler via the configuration manager]({})", new Object[]{this.maxQuartzJobDurationAcceptable, "/system/console/configMgr/org.apache.sling.commons.scheduler.impl.QuartzScheduler"});
            }
        }
        catch (Exception e) {
            this.logger.warn("execute: metrics invocation failed with exception: {}", (Throwable)e);
            resultLog.healthCheckError("execute: metrics invocation failed with exception: {}", new Object[]{e});
        }
        return new Result((ResultLog)resultLog);
    }

    @ObjectClassDefinition(name="Apache Sling Scheduler Health Check Config", description="Apache Sling Scheduler Health Check Config")
    public static @interface Config {
        @AttributeDefinition(name="Acceptable Duration Millis", description="Maximum a job should take (in millis) for it to be acceptable. Best to set this equal or higher to org.apache.sling.commons.scheduler.impl.QuartzScheduler.slowThresholdMillis")
        public long max_quartzJob_duration_acceptable() default 60000L;
    }
}

