/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base;

import aQute.bnd.annotation.ProviderType;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.AbstractSlingRepositoryManager;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public abstract class AbstractSlingRepository2
implements SlingRepository {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AbstractSlingRepositoryManager manager;
    private final Bundle usingBundle;

    protected AbstractSlingRepository2(AbstractSlingRepositoryManager manager, Bundle usingBundle) {
        this.manager = manager;
        this.usingBundle = usingBundle;
    }

    protected final AbstractSlingRepositoryManager getSlingRepositoryManager() {
        return this.manager;
    }

    protected final Repository getRepository() {
        return this.getSlingRepositoryManager().getRepository();
    }

    public final String getDefaultWorkspace() {
        return this.getSlingRepositoryManager().getDefaultWorkspace();
    }

    protected abstract Session createAdministrativeSession(String var1) throws RepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session createServiceSession(String serviceUserName, String workspace) throws RepositoryException {
        Session admin = null;
        try {
            admin = this.createAdministrativeSession(workspace);
            Session session = admin.impersonate((Credentials)new SimpleCredentials(serviceUserName, new char[0]));
            return session;
        }
        finally {
            if (admin != null) {
                admin.logout();
            }
        }
    }

    public Session login() throws LoginException, RepositoryException {
        return this.login(null, null);
    }

    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return this.login(credentials, null);
    }

    public Session login(String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, workspace);
    }

    public Session login(Credentials credentials, String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (credentials == null) {
            credentials = new GuestCredentials();
        }
        if (workspace == null) {
            workspace = this.getDefaultWorkspace();
        }
        try {
            this.logger.debug("login: Logging in to workspace '" + workspace + "'");
            Repository repository = this.getRepository();
            if (this.getRepository() == null) {
                throw new RepositoryException("Sling Repository not ready");
            }
            Session session = repository.login(credentials, workspace);
            return session;
        }
        catch (RuntimeException re) {
            throw new RepositoryException(re.getMessage(), (Throwable)re);
        }
    }

    public final Session loginService(String subServiceName, String workspace) throws LoginException, RepositoryException {
        String userName;
        ServiceUserMapper serviceUserMapper = this.getSlingRepositoryManager().getServiceUserMapper();
        String string = userName = serviceUserMapper != null ? serviceUserMapper.getServiceUserID(this.usingBundle, subServiceName) : null;
        if (userName == null) {
            throw new LoginException("Cannot derive user name for bundle " + this.usingBundle + " and sub service " + subServiceName);
        }
        return this.createServiceSession(userName, workspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session impersonateFromService(String subServiceName, Credentials credentials, String workspaceName) throws LoginException, RepositoryException {
        String userName;
        ServiceUserMapper serviceUserMapper = this.getSlingRepositoryManager().getServiceUserMapper();
        String string = userName = serviceUserMapper != null ? serviceUserMapper.getServiceUserID(this.usingBundle, subServiceName) : null;
        if (userName == null) {
            throw new LoginException("Cannot derive user name for bundle " + this.usingBundle + " and sub service " + subServiceName);
        }
        Session serviceSession = null;
        try {
            serviceSession = this.createServiceSession(userName, workspaceName);
            Session session = serviceSession.impersonate(credentials);
            return session;
        }
        finally {
            if (serviceSession != null) {
                serviceSession.logout();
            }
        }
    }

    public final Session loginAdministrative(String workspace) throws RepositoryException {
        if (this.getSlingRepositoryManager().isDisableLoginAdministrative()) {
            this.logger.error("SlingRepository.loginAdministrative is disabled. Please use SlingRepository.loginService.");
            throw new LoginException();
        }
        this.logger.debug("SlingRepository.loginAdministrative is deprecated. Please use SlingRepository.loginService.");
        return this.createAdministrativeSession(workspace);
    }

    public String getDescriptor(String name) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.getDescriptor(name);
        }
        this.logger.error("getDescriptor: Repository not available");
        return null;
    }

    public String[] getDescriptorKeys() {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.getDescriptorKeys();
        }
        this.logger.error("getDescriptorKeys: Repository not available");
        return new String[0];
    }

    public Value getDescriptorValue(String key) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.getDescriptorValue(key);
        }
        this.logger.error("getDescriptorValue: Repository not available");
        return null;
    }

    public Value[] getDescriptorValues(String key) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.getDescriptorValues(key);
        }
        this.logger.error("getDescriptorValues: Repository not available");
        return null;
    }

    public boolean isSingleValueDescriptor(String key) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.isSingleValueDescriptor(key);
        }
        this.logger.error("isSingleValueDescriptor: Repository not available");
        return false;
    }

    public boolean isStandardDescriptor(String key) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.isStandardDescriptor(key);
        }
        this.logger.error("isStandardDescriptor: Repository not available");
        return false;
    }
}

