/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base;

import aQute.bnd.annotation.ProviderType;
import java.util.Arrays;
import java.util.Dictionary;
import javax.jcr.Repository;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.api.SlingRepositoryInitializer;
import org.apache.sling.jcr.base.AbstractSlingRepository2;
import org.apache.sling.jcr.base.internal.loader.Loader;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public abstract class AbstractSlingRepositoryManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile BundleContext bundleContext;
    private volatile Repository repository;
    private volatile AbstractSlingRepository2 masterSlingRepository;
    private volatile ServiceRegistration repositoryService;
    private volatile String defaultWorkspace;
    private volatile boolean disableLoginAdministrative;
    private volatile ServiceTracker repoInitializerTracker;
    private volatile Loader loader;

    public final String getDefaultWorkspace() {
        return this.defaultWorkspace;
    }

    public final boolean isDisableLoginAdministrative() {
        return this.disableLoginAdministrative;
    }

    protected abstract ServiceUserMapper getServiceUserMapper();

    protected abstract Repository acquireRepository();

    protected final ServiceRegistration registerService() {
        Dictionary<String, Object> props = this.getServiceRegistrationProperties();
        String[] interfaces = this.getServiceRegistrationInterfaces();
        return this.bundleContext.registerService(interfaces, (Object)new ServiceFactory(){

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                return AbstractSlingRepositoryManager.this.create(bundle);
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
                AbstractSlingRepositoryManager.this.destroy((AbstractSlingRepository2)service);
            }
        }, props);
    }

    protected abstract Dictionary<String, Object> getServiceRegistrationProperties();

    protected String[] getServiceRegistrationInterfaces() {
        return new String[]{SlingRepository.class.getName(), Repository.class.getName()};
    }

    protected abstract AbstractSlingRepository2 create(Bundle var1);

    protected abstract void destroy(AbstractSlingRepository2 var1);

    protected final Repository getRepository() {
        return this.repository;
    }

    protected final void unregisterService(ServiceRegistration serviceRegistration) {
        serviceRegistration.unregister();
    }

    protected abstract void disposeRepository(Repository var1);

    protected final boolean start(BundleContext bundleContext, String defaultWorkspace, boolean disableLoginAdministrative) {
        block7: {
            if (this.bundleContext != null) {
                this.log.debug("start: Repository already started and registered");
                return true;
            }
            this.bundleContext = bundleContext;
            this.defaultWorkspace = defaultWorkspace;
            this.disableLoginAdministrative = disableLoginAdministrative;
            this.repoInitializerTracker = new ServiceTracker(bundleContext, SlingRepositoryInitializer.class.getName(), null);
            this.repoInitializerTracker.open();
            try {
                this.log.debug("start: calling acquireRepository()");
                Repository newRepo = this.acquireRepository();
                if (newRepo == null) break block7;
                this.log.debug("start: got a Repository");
                this.repository = newRepo;
                this.masterSlingRepository = this.create(this.bundleContext.getBundle());
                this.log.debug("start: setting up Loader");
                this.loader = new Loader(this.masterSlingRepository, this.bundleContext);
                this.log.debug("start: calling SlingRepositoryInitializer");
                Throwable t = null;
                try {
                    this.executeRepositoryInitializers(this.masterSlingRepository);
                }
                catch (Exception e) {
                    t = e;
                }
                catch (Error e) {
                    t = e;
                }
                if (t != null) {
                    this.log.error("Exception in a SlingRepositoryInitializer, SlingRepository service registration aborted", t);
                    return false;
                }
                this.log.debug("start: calling registerService()");
                this.repositoryService = this.registerService();
                this.log.debug("start: registerService() successful, registration=" + this.repositoryService);
                return true;
            }
            catch (Throwable t) {
                this.log.error("start: Uncaught Throwable trying to access Repository, calling stopRepository()", t);
                this.stop();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRepositoryInitializers(SlingRepository repo) throws Exception {
        Object[] refs = this.repoInitializerTracker.getServiceReferences();
        if (refs == null || refs.length == 0) {
            this.log.debug("No SlingRepositoryInitializer services found");
            return;
        }
        Arrays.sort(refs);
        for (Object ref : refs) {
            SlingRepositoryInitializer sri = (SlingRepositoryInitializer)this.bundleContext.getService((ServiceReference)ref);
            this.log.debug("Executing {}", (Object)sri);
            try {
                sri.processRepository(repo);
            }
            finally {
                this.bundleContext.ungetService((ServiceReference)ref);
            }
        }
    }

    protected final void stop() {
        if (this.repoInitializerTracker != null) {
            this.repoInitializerTracker.close();
            this.repoInitializerTracker = null;
        }
        if (this.repository != null || this.repositoryService != null) {
            this.log.info("stop: Repository still running, forcing shutdown");
            try {
                if (this.repositoryService != null) {
                    try {
                        this.log.debug("stop: Unregistering SlingRepository service, registration=" + this.repositoryService);
                        this.unregisterService(this.repositoryService);
                    }
                    catch (Throwable t) {
                        this.log.info("stop: Uncaught problem unregistering the repository service", t);
                    }
                    this.repositoryService = null;
                }
                if (this.repository != null) {
                    Repository oldRepo = this.repository;
                    this.repository = null;
                    if (this.loader != null) {
                        this.loader.dispose();
                        this.loader = null;
                    }
                    this.destroy(this.masterSlingRepository);
                    try {
                        this.disposeRepository(oldRepo);
                    }
                    catch (Throwable t) {
                        this.log.info("stop: Uncaught problem disposing the repository", t);
                    }
                }
            }
            catch (Throwable t) {
                this.log.warn("stop: Unexpected problem stopping repository", t);
            }
        }
        this.repositoryService = null;
        this.repository = null;
        this.defaultWorkspace = null;
        this.bundleContext = null;
    }
}

