/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Configuration;
import org.apache.sling.provisioning.model.EffectiveModelProcessor;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.KeyValueMap;
import org.apache.sling.provisioning.model.MergeUtility;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelProcessor;
import org.apache.sling.provisioning.model.ModelResolveUtility;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.Traceable;

public abstract class ModelUtility {
    @Deprecated
    public static void merge(Model base, Model additional) {
        MergeUtility.merge(base, additional);
    }

    @Deprecated
    public static void merge(Model base, Model additional, boolean handleRemove) {
        MergeUtility.MergeOptions opts = new MergeUtility.MergeOptions();
        opts.setHandleRemoveRunMode(handleRemove);
        MergeUtility.merge(base, additional, opts);
    }

    @Deprecated
    public static Model getEffectiveModel(Model model, VariableResolver resolver) {
        return ModelUtility.getEffectiveModel(model, new ResolverOptions().variableResolver(resolver));
    }

    public static Model getEffectiveModel(Model model) {
        return ModelUtility.getEffectiveModel(model, new ResolverOptions());
    }

    public static Model getEffectiveModel(Model model, ResolverOptions options) {
        EffectiveModelProcessor processor = new EffectiveModelProcessor(options);
        return processor.process(model);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Traceable, String> validate(Model model) {
        HashMap<Traceable, String> errors = new HashMap<Traceable, String>();
        for (Feature feature : model.getFeatures()) {
            if (feature.getName() == null || feature.getName().isEmpty()) {
                errors.put(feature, "Name is required for a feature.");
            }
            for (RunMode runMode : feature.getRunModes()) {
                Object[] rm = runMode.getNames();
                if (rm != null) {
                    boolean hasSpecial = false;
                    for (String string : rm) {
                        if (!string.startsWith(":")) continue;
                        if (hasSpecial) {
                            errors.put(runMode, "Invalid modes " + Arrays.toString(rm));
                            break;
                        }
                        hasSpecial = true;
                    }
                }
                for (ArtifactGroup sl : runMode.getArtifactGroups()) {
                    if (sl.getStartLevel() < 0) {
                        errors.put(sl, "Invalid start level " + sl.getStartLevel());
                    }
                    for (Artifact a : sl) {
                        void var11_25;
                        Object var11_17 = null;
                        if (a.getGroupId() == null || a.getGroupId().isEmpty()) {
                            String string = "groupId missing";
                        }
                        if (a.getArtifactId() == null || a.getArtifactId().isEmpty()) {
                            void var11_19;
                            String string = (var11_19 != null ? (String)var11_19 + ", " : "") + "artifactId missing";
                        }
                        if (a.getVersion() == null || a.getVersion().isEmpty()) {
                            void var11_21;
                            String string = (var11_21 != null ? (String)var11_21 + ", " : "") + "version missing";
                        }
                        if (a.getType() == null || a.getType().isEmpty()) {
                            void var11_23;
                            String string = (var11_23 != null ? (String)var11_23 + ", " : "") + "type missing";
                        }
                        if (var11_25 == null) continue;
                        errors.put(a, (String)var11_25);
                    }
                }
                for (Configuration c : runMode.getConfigurations()) {
                    String error = null;
                    if (c.getPid() == null || c.getPid().isEmpty()) {
                        error = "pid missing";
                    }
                    if (c.isSpecial() && c.getFactoryPid() != null) {
                        error = (error != null ? error + ", " : "") + "factory pid not allowed for special configuration";
                    }
                    if (c.getProperties().isEmpty()) {
                        error = (error != null ? error + ", " : "") + "configuration properties missing";
                    }
                    if (error == null) continue;
                    errors.put(c, error);
                }
            }
        }
        if (errors.size() == 0) {
            return null;
        }
        return errors;
    }

    public static Model applyVariables(Model model, final VariableResolver resolver) {
        final HashMap collectedVars = new HashMap();
        VariableResolver variableCollector = new VariableResolver(){

            @Override
            public String resolve(Feature feature, String name) {
                String value = resolver.resolve(feature, name);
                if (value != null) {
                    HashMap<String, String> featureVars = (HashMap<String, String>)collectedVars.get(feature.getName());
                    if (featureVars == null) {
                        featureVars = new HashMap<String, String>();
                        collectedVars.put(feature.getName(), featureVars);
                    }
                    featureVars.put(name, value);
                }
                return value;
            }
        };
        new EffectiveModelProcessor(new ResolverOptions().variableResolver(variableCollector)).process(model);
        ModelProcessor variablesUpdater = new ModelProcessor(){

            @Override
            protected KeyValueMap<String> processVariables(KeyValueMap<String> variables, Feature newFeature) {
                KeyValueMap<String> newVariables = new KeyValueMap<String>();
                Map featureVars = (Map)collectedVars.get(newFeature.getName());
                if (featureVars != null) {
                    for (Map.Entry entry : featureVars.entrySet()) {
                        newVariables.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                return newVariables;
            }
        };
        return variablesUpdater.process(model);
    }

    public static Model applyArtifactVersions(Model model, final ArtifactVersionResolver resolver) {
        ModelProcessor versionUpdater = new ModelProcessor(){

            @Override
            protected Artifact processArtifact(Artifact artifact, Feature newFeature, RunMode newRunMode) {
                String newVersion = ModelResolveUtility.resolveArtifactVersion(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier(), artifact.getType(), resolver);
                return new Artifact(artifact.getGroupId(), artifact.getArtifactId(), newVersion, artifact.getClassifier(), artifact.getType(), artifact.getMetadata());
            }
        };
        return versionUpdater.process(model);
    }

    public static final class ResolverOptions {
        private VariableResolver variableResolver;
        private ArtifactVersionResolver artifactVersionResolver;

        public VariableResolver getVariableResolver() {
            return this.variableResolver;
        }

        public ResolverOptions variableResolver(VariableResolver variableResolver) {
            this.variableResolver = variableResolver;
            return this;
        }

        public ArtifactVersionResolver getArtifactVersionResolver() {
            return this.artifactVersionResolver;
        }

        public ResolverOptions artifactVersionResolver(ArtifactVersionResolver dependencyVersionResolver) {
            this.artifactVersionResolver = dependencyVersionResolver;
            return this;
        }
    }

    public static interface ArtifactVersionResolver {
        public String resolve(Artifact var1);
    }

    public static interface VariableResolver {
        public String resolve(Feature var1, String var2);
    }
}

