/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model;

public class Version
implements Comparable<Version> {
    private final int majorVersion;
    private final int minorVersion;
    private final int microVersion;
    private final String qualifier;

    public Version(String version) {
        int pos;
        String[] parts = version.split("\\.");
        if (parts.length > 4) {
            throw new IllegalArgumentException("Invalid version " + version);
        }
        if (parts.length < 4 && (pos = parts[parts.length - 1].indexOf(45)) != -1) {
            String[] newParts = new String[4];
            String string = newParts[0] = parts.length > 1 ? parts[0] : parts[0].substring(0, pos);
            String string2 = parts.length > 2 ? parts[1] : (newParts[1] = parts.length > 1 ? parts[1].substring(0, pos) : "0");
            newParts[2] = parts.length > 3 ? parts[2] : (parts.length > 2 ? parts[2].substring(0, pos) : "0");
            newParts[3] = parts[parts.length - 1].substring(pos + 1);
            parts = newParts;
        }
        this.majorVersion = Version.parseInt(parts[0], version);
        this.minorVersion = parts.length > 1 ? Version.parseInt(parts[1], version) : 0;
        this.microVersion = parts.length > 2 ? Version.parseInt(parts[2], version) : 0;
        this.qualifier = parts.length > 3 ? parts[3] : "";
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMicroVersion() {
        return this.microVersion;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    private static int parseInt(String value, String version) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version " + version);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.majorVersion;
        result = 31 * result + this.microVersion;
        result = 31 * result + this.minorVersion;
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.majorVersion != other.majorVersion) {
            return false;
        }
        if (this.microVersion != other.microVersion) {
            return false;
        }
        if (this.minorVersion != other.minorVersion) {
            return false;
        }
        return !(this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier));
    }

    @Override
    public int compareTo(Version other) {
        int result = 0;
        if (other != this && (result = this.majorVersion - other.majorVersion) == 0 && (result = this.minorVersion - other.minorVersion) == 0 && (result = this.microVersion - other.microVersion) == 0 && (result = this.qualifier.compareTo(other.qualifier)) != 0) {
            if ("SNAPSHOT".equals(this.qualifier)) {
                result = -1;
            } else if ("SNAPSHOT".equals(other.qualifier)) {
                result = 1;
            }
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.majorVersion) + "." + String.valueOf(this.minorVersion + "." + String.valueOf(this.microVersion) + (this.qualifier.length() == 0 ? "" : "." + this.qualifier));
    }
}

