/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.tree.params;

import java.util.LinkedHashMap;
import java.util.Map;

class ParametersParser {
    private StringBuilder name;
    private StringBuilder value;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private boolean invalid;

    ParametersParser() {
    }

    public int parseParameters(char[] chars, int from, boolean dotAllowed) {
        this.resetCurrentParameter();
        this.parameters.clear();
        this.invalid = false;
        ParamsState state = ParamsState.INIT;
        block8: for (int i = from; i <= chars.length; ++i) {
            char c = i == chars.length ? (char)'\u0000' : chars[i];
            switch (state) {
                case INIT: {
                    if (c == ';') {
                        state = ParamsState.NAME;
                        continue block8;
                    }
                    if (c != '.' && c != '/' && c != '\u0000') continue block8;
                    this.invalid = true;
                    return i;
                }
                case NAME: {
                    if (c == '=') {
                        state = ParamsState.EQUALS;
                        continue block8;
                    }
                    if (c == '.' || c == '/' || c == '\u0000') {
                        this.invalid = true;
                        return i;
                    }
                    if (c == ';') {
                        this.resetCurrentParameter();
                        continue block8;
                    }
                    this.name.append(c);
                    continue block8;
                }
                case EQUALS: {
                    if (c == '\'') {
                        state = ParamsState.QUOTED_VALUE;
                        continue block8;
                    }
                    if (c == '.' || c == '/' || c == '\u0000') {
                        this.addParameter();
                        return i;
                    }
                    if (c == ';') {
                        state = ParamsState.NAME;
                        this.addParameter();
                        continue block8;
                    }
                    state = ParamsState.VALUE;
                    this.value.append(c);
                    continue block8;
                }
                case QUOTED_VALUE: {
                    if (c == '\'') {
                        state = ParamsState.QUOTE_END;
                        this.addParameter();
                        continue block8;
                    }
                    if (c == '\u0000') {
                        this.invalid = true;
                        return i;
                    }
                    this.value.append(c);
                    continue block8;
                }
                case VALUE: {
                    if (c == ';') {
                        state = ParamsState.NAME;
                        this.addParameter();
                        continue block8;
                    }
                    if (c == '.' && !dotAllowed || c == '/' || c == '\u0000') {
                        this.addParameter();
                        return i;
                    }
                    this.value.append(c);
                    continue block8;
                }
                case QUOTE_END: {
                    if (c == ';') {
                        state = ParamsState.NAME;
                        continue block8;
                    }
                    return i;
                }
            }
        }
        return chars.length;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    private void resetCurrentParameter() {
        this.name = new StringBuilder();
        this.value = new StringBuilder();
    }

    private void addParameter() {
        this.parameters.put(this.name.toString(), this.value.toString());
        this.name = new StringBuilder();
        this.value = new StringBuilder();
    }

    private static enum ParamsState {
        INIT,
        NAME,
        EQUALS,
        VALUE,
        QUOTED_VALUE,
        QUOTE_END;

    }
}

