/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.observation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.path.PathSet;
import org.apache.sling.spi.resource.provider.ObserverConfiguration;

public class BasicObserverConfiguration
implements ObserverConfiguration {
    private final boolean includeExternal;
    private final PathSet paths;
    private final PathSet excludedPaths;
    private final Set<ResourceChange.ChangeType> changeTypes;

    public BasicObserverConfiguration(String path, Set<ResourceChange.ChangeType> types, boolean isExternal, PathSet excludePaths) {
        this.includeExternal = isExternal;
        this.paths = PathSet.fromStrings((String[])new String[]{path});
        this.changeTypes = Collections.unmodifiableSet(types);
        this.excludedPaths = excludePaths.getSubset(path);
    }

    public BasicObserverConfiguration(PathSet set) {
        this.includeExternal = false;
        this.paths = set;
        HashSet<ResourceChange.ChangeType> types = new HashSet<ResourceChange.ChangeType>();
        types.add(ResourceChange.ChangeType.PROVIDER_ADDED);
        types.add(ResourceChange.ChangeType.PROVIDER_REMOVED);
        this.changeTypes = Collections.unmodifiableSet(types);
        this.excludedPaths = PathSet.EMPTY_SET;
    }

    public boolean includeExternal() {
        return this.includeExternal;
    }

    public PathSet getPaths() {
        return this.paths;
    }

    public PathSet getExcludedPaths() {
        return this.excludedPaths;
    }

    public Set<ResourceChange.ChangeType> getChangeTypes() {
        return this.changeTypes;
    }

    public boolean matches(String path) {
        return this.paths.matches(path) != null && this.excludedPaths.matches(path) == null;
    }
}

