/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl;

import java.util.Map;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.SideEffectVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.ArrayLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BooleanConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Identifier;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NullLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NumericConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.PropertyAccess;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.TernaryOperator;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.UnaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.UnaryOperator;
import org.apache.sling.scripting.sightly.java.compiler.impl.GenHelper;
import org.apache.sling.scripting.sightly.java.compiler.impl.JavaSource;
import org.apache.sling.scripting.sightly.java.compiler.impl.Type;
import org.apache.sling.scripting.sightly.java.compiler.impl.TypeInfo;
import org.apache.sling.scripting.sightly.java.compiler.impl.VariableAnalyzer;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.Operators;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.UnaryOpGen;

public final class ExpressionTranslator
extends SideEffectVisitor {
    private final JavaSource source;
    private final VariableAnalyzer analyzer;
    private final TypeInfo typeInfo;

    private ExpressionTranslator(JavaSource source, VariableAnalyzer analyzer, TypeInfo typeInfo) {
        this.source = source;
        this.analyzer = analyzer;
        this.typeInfo = typeInfo;
    }

    public static void buildExpression(ExpressionNode node, JavaSource source, VariableAnalyzer analyzer, TypeInfo typeInfo) {
        ExpressionTranslator builder = new ExpressionTranslator(source, analyzer, typeInfo);
        builder.traverse(node);
    }

    public void traverse(ExpressionNode node) {
        this.visit(node);
    }

    private void visit(ExpressionNode node) {
        node.accept((NodeVisitor)this);
    }

    public void visit(PropertyAccess propertyAccess) {
        if (this.typeInfo.typeOf(propertyAccess.getTarget()) == Type.MAP) {
            this.visit(propertyAccess.getTarget());
            this.source.startCall("get", true);
            this.visit(propertyAccess.getProperty());
            this.source.endCall();
        } else {
            this.source.objectModel().startCall("resolveProperty", true);
            this.visit(propertyAccess.getTarget());
            this.source.separateArgument();
            this.visit(propertyAccess.getProperty());
            this.source.endCall();
        }
    }

    public void visit(Identifier identifier) {
        String safeName = this.analyzer.assignedName(identifier.getName());
        this.source.append(safeName);
    }

    public void visit(StringConstant text) {
        this.source.stringLiteral(text.getText());
    }

    public void visit(BinaryOperation binaryOperation) {
        BinaryOpGen opGen = Operators.generatorFor(binaryOperation.getOperator());
        this.source.startExpression();
        opGen.generate(this.source, this, this.typeInfo.getTyped(binaryOperation.getLeftOperand()), this.typeInfo.getTyped(binaryOperation.getRightOperand()));
        this.source.endExpression();
    }

    public void visit(BooleanConstant booleanConstant) {
        this.source.append(Boolean.toString(booleanConstant.getValue()));
    }

    public void visit(NumericConstant numericConstant) {
        this.source.append(numericConstant.getValue().toString());
    }

    public void visit(UnaryOperation unaryOperation) {
        UnaryOperator operator = unaryOperation.getOperator();
        ExpressionNode operand = unaryOperation.getTarget();
        UnaryOpGen unaryOpGen = Operators.generatorFor(operator);
        this.source.startExpression();
        unaryOpGen.generate(this.source, this, this.typeInfo.getTyped(operand));
        this.source.endExpression();
    }

    public void visit(TernaryOperator ternaryOperator) {
        GenHelper.generateTernary(this.source, this, this.typeInfo.getTyped(ternaryOperator.getCondition()), this.typeInfo.getTyped(ternaryOperator.getThenBranch()), this.typeInfo.getTyped(ternaryOperator.getElseBranch()));
    }

    public void visit(RuntimeCall runtimeCall) {
        this.source.startMethodCall("renderContext", "call").stringLiteral(runtimeCall.getFunctionName());
        for (ExpressionNode arg : runtimeCall.getArguments()) {
            this.source.separateArgument();
            this.visit(arg);
        }
        this.source.endCall();
    }

    public void visit(MapLiteral mapLiteral) {
        this.source.startCall("obj").endCall();
        for (Map.Entry entry : mapLiteral.getMap().entrySet()) {
            this.source.startCall("with", true).stringLiteral((String)entry.getKey()).separateArgument();
            this.visit((ExpressionNode)entry.getValue());
            this.source.endCall();
        }
    }

    public void visit(ArrayLiteral arrayLiteral) {
        this.source.startExpression().startArray();
        boolean needsComma = false;
        for (ExpressionNode node : arrayLiteral.getItems()) {
            if (needsComma) {
                this.source.separateArgument();
            }
            this.visit(node);
            needsComma = true;
        }
        this.source.endArray().endExpression();
    }

    public void visit(NullLiteral nullLiteral) {
        this.source.nullLiteral();
    }

    public VariableAnalyzer getAnalyzer() {
        return this.analyzer;
    }
}

