/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.SideEffectVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Identifier;
import org.apache.sling.scripting.sightly.java.compiler.impl.ExpressionTranslator;
import org.apache.sling.scripting.sightly.java.compiler.impl.JavaSource;
import org.apache.sling.scripting.sightly.java.compiler.impl.Type;
import org.apache.sling.scripting.sightly.java.compiler.impl.VariableDescriptor;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.TypedNode;

public class GenHelper {
    private static final Map<Type, String> dynamicCoercions = new HashMap<Type, String>();

    public static void generateTernary(JavaSource source, SideEffectVisitor visitor, TypedNode condition, TypedNode thenBranch, TypedNode elseBranch) {
        source.startExpression();
        GenHelper.typeCoercion(source, visitor, condition, Type.BOOLEAN);
        source.conditional();
        thenBranch.getNode().accept((NodeVisitor)visitor);
        source.conditionalBranchSep();
        elseBranch.getNode().accept((NodeVisitor)visitor);
        source.endExpression();
    }

    public static void typeCoercion(JavaSource source, SideEffectVisitor visitor, TypedNode node, Type type) {
        if (type == node.getType() || type == Type.UNKNOWN) {
            node.getNode().accept((NodeVisitor)visitor);
        } else if (type == Type.LONG && node.getType() == Type.DOUBLE) {
            GenHelper.callLongCoercion(source, visitor, node.getNode());
        } else {
            String coercionMethod = dynamicCoercions.get((Object)type);
            if (coercionMethod == null) {
                throw new UnsupportedOperationException("Cannot generate coercion to type " + (Object)((Object)type));
            }
            GenHelper.callDynamicCoercion(source, visitor, node.getNode(), dynamicCoercions.get((Object)type));
        }
    }

    public static void listCoercion(JavaSource source, ExpressionTranslator visitor, TypedNode typedNode) {
        ExpressionNode node = typedNode.getNode();
        if (node instanceof Identifier) {
            VariableDescriptor descriptor = visitor.getAnalyzer().descriptor(((Identifier)node).getName());
            String listCoercionVar = descriptor.requireListCoercion();
            source.startExpression().append(listCoercionVar).equality().nullLiteral().conditional().startExpression().append(listCoercionVar).assign().objectModel().startCall("toCollection", true);
            node.accept((NodeVisitor)visitor);
            source.endCall().endExpression().conditionalBranchSep().append(listCoercionVar).endExpression();
        } else {
            source.objectModel().startCall("toCollection", true);
            typedNode.getNode().accept((NodeVisitor)visitor);
            source.endCall();
        }
    }

    private static void callLongCoercion(JavaSource source, SideEffectVisitor visitor, ExpressionNode node) {
        source.cast(Type.LONG.getNativeClass());
        source.startExpression();
        node.accept((NodeVisitor)visitor);
        source.endExpression();
    }

    private static void callDynamicCoercion(JavaSource source, SideEffectVisitor visitor, ExpressionNode node, String methodName) {
        source.objectModel().startCall(methodName, true);
        node.accept((NodeVisitor)visitor);
        source.endCall();
    }

    static {
        dynamicCoercions.put(Type.STRING, "toString");
        dynamicCoercions.put(Type.BOOLEAN, "toBoolean");
        dynamicCoercions.put(Type.LONG, "toNumber");
        dynamicCoercions.put(Type.DOUBLE, "toNumber");
    }
}

