/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.ArrayLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BooleanConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Identifier;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NullLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NumericConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.PropertyAccess;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.TernaryOperator;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.UnaryOperation;
import org.apache.sling.scripting.sightly.java.compiler.impl.Type;
import org.apache.sling.scripting.sightly.java.compiler.impl.TypeInfo;
import org.apache.sling.scripting.sightly.java.compiler.impl.VariableAnalyzer;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.Operators;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.UnaryOpGen;

public final class TypeInference
implements NodeVisitor<Type> {
    private final VariableAnalyzer analyzer;
    private final Map<ExpressionNode, Type> inferMap = new IdentityHashMap<ExpressionNode, Type>();

    public static TypeInfo inferTypes(ExpressionNode node, VariableAnalyzer analyzer) {
        TypeInference typeInference = new TypeInference(analyzer);
        typeInference.infer(node);
        return new TypeInfo(typeInference.inferMap);
    }

    private TypeInference(VariableAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    private Type infer(ExpressionNode node) {
        Type type = (Type)((Object)node.accept((NodeVisitor)this));
        this.inferMap.put(node, type);
        return type;
    }

    public Type evaluate(PropertyAccess propertyAccess) {
        this.infer(propertyAccess.getTarget());
        this.infer(propertyAccess.getProperty());
        return Type.UNKNOWN;
    }

    public Type evaluate(Identifier identifier) {
        return this.analyzer.descriptor(identifier.getName()).getType();
    }

    public Type evaluate(StringConstant text) {
        return Type.STRING;
    }

    public Type evaluate(BinaryOperation binaryOperation) {
        Type leftType = this.infer(binaryOperation.getLeftOperand());
        Type rightType = this.infer(binaryOperation.getRightOperand());
        BinaryOpGen opGen = Operators.generatorFor(binaryOperation.getOperator());
        return opGen.returnType(leftType, rightType);
    }

    public Type evaluate(BooleanConstant booleanConstant) {
        return Type.BOOLEAN;
    }

    public Type evaluate(NumericConstant numericConstant) {
        Number number = numericConstant.getValue();
        if (number instanceof Integer || number instanceof Long) {
            return Type.LONG;
        }
        if (number instanceof Float || number instanceof Double) {
            return Type.DOUBLE;
        }
        return Type.UNKNOWN;
    }

    public Type evaluate(UnaryOperation unaryOperation) {
        this.infer(unaryOperation.getTarget());
        UnaryOpGen opGen = Operators.generatorFor(unaryOperation.getOperator());
        return opGen.returnType(this.infer(unaryOperation.getTarget()));
    }

    public Type evaluate(TernaryOperator ternaryOperator) {
        this.infer(ternaryOperator.getCondition());
        Type thenType = this.infer(ternaryOperator.getThenBranch());
        Type elseType = this.infer(ternaryOperator.getElseBranch());
        if (thenType.equals((Object)elseType)) {
            return thenType;
        }
        return Type.UNKNOWN;
    }

    public Type evaluate(RuntimeCall runtimeCall) {
        this.inferAll(runtimeCall.getArguments());
        return Type.UNKNOWN;
    }

    public Type evaluate(MapLiteral mapLiteral) {
        this.inferAll(mapLiteral.getMap().values());
        return Type.MAP;
    }

    public Type evaluate(ArrayLiteral arrayLiteral) {
        this.inferAll(arrayLiteral.getItems());
        return Type.UNKNOWN;
    }

    public Type evaluate(NullLiteral nullLiteral) {
        return Type.UNKNOWN;
    }

    private void inferAll(Iterable<ExpressionNode> nodes) {
        for (ExpressionNode node : nodes) {
            this.infer(node);
        }
    }
}

