/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sling.scripting.sightly.java.compiler.CompilationOutput;
import org.apache.sling.scripting.sightly.java.compiler.impl.CompilationOutputImpl;
import org.apache.sling.scripting.sightly.java.compiler.impl.JavaSource;

public class UnitBuilder {
    private final JavaSource source = new JavaSource();
    private final Set<String> parameters;
    private final Map<String, UnitBuilder> subTemplates = new HashMap<String, UnitBuilder>();

    public UnitBuilder() {
        this(Collections.emptySet());
    }

    public UnitBuilder(Set<String> parameters) {
        this.parameters = parameters;
    }

    public UnitBuilder newSubBuilder(String name, Set<String> parameters) {
        UnitBuilder unitBuilder = new UnitBuilder(parameters);
        this.subTemplates.put(name, unitBuilder);
        return unitBuilder;
    }

    public JavaSource getSource() {
        return this.source;
    }

    public Set<String> getParameters() {
        return this.parameters;
    }

    public CompilationOutput build() {
        HashMap<String, CompilationOutput> map = new HashMap<String, CompilationOutput>();
        for (Map.Entry<String, UnitBuilder> entry : this.subTemplates.entrySet()) {
            map.put(entry.getKey(), entry.getValue().build());
        }
        return new CompilationOutputImpl(this.source.toString(), map);
    }
}

