/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.render;

import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.scripting.sightly.Record;
import org.apache.sling.scripting.sightly.compiler.util.ObjectModel;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;

public abstract class AbstractRuntimeObjectModel
implements RuntimeObjectModel {
    public static final Set<Class<?>> PRIMITIVE_CLASSES = ObjectModel.PRIMITIVE_CLASSES;
    public static final String TO_STRING_METHOD = "toString";

    @Override
    public boolean isPrimitive(Object obj) {
        return ObjectModel.isPrimitive((Object)obj);
    }

    @Override
    public boolean isDate(Object target) {
        return target instanceof Date || target instanceof Calendar;
    }

    @Override
    public boolean isNumber(Object target) {
        if (target == null) {
            return false;
        }
        if (target instanceof Number) {
            return true;
        }
        String value = this.toString(target);
        return NumberUtils.isCreatable((String)value);
    }

    @Override
    public boolean isCollection(Object target) {
        return target instanceof Collection || target instanceof Object[] || target instanceof Iterable || target instanceof Iterator;
    }

    @Override
    public Object resolveProperty(Object target, Object property) {
        Object resolved = property instanceof Number ? ObjectModel.getIndex((Object)target, (int)((Number)property).intValue()) : this.getProperty(target, property);
        return resolved;
    }

    @Override
    public boolean toBoolean(Object object) {
        return ObjectModel.toBoolean((Object)object);
    }

    @Override
    public Number toNumber(Object object) {
        return ObjectModel.toNumber((Object)object);
    }

    @Override
    public Date toDate(Object object) {
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        return null;
    }

    @Override
    public String toString(Object target) {
        return ObjectModel.toString((Object)target);
    }

    @Override
    public Collection<Object> toCollection(Object object) {
        if (object instanceof Record) {
            return ((Record)object).getPropertyNames();
        }
        return ObjectModel.toCollection((Object)object);
    }

    @Override
    public Map toMap(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object instanceof Record) {
            HashMap map = new HashMap();
            Record record = (Record)object;
            Set<String> properties = record.getPropertyNames();
            for (String property : properties) {
                map.put(property, record.getProperty(property));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    protected Object getProperty(Object target, Object propertyObj) {
        String property = ObjectModel.toString((Object)propertyObj);
        Object result = null;
        if (target instanceof Record) {
            result = ((Record)target).getProperty(property);
        }
        if (result == null) {
            result = ObjectModel.resolveProperty((Object)target, (Object)property);
        }
        return result;
    }

    @Deprecated
    protected Collection<Object> obtainCollection(Object obj) {
        return ObjectModel.toCollection((Object)obj);
    }

    @Deprecated
    protected String objectToString(Object obj) {
        return ObjectModel.toString((Object)obj);
    }

    @Deprecated
    protected String collectionToString(Collection<?> col) {
        return ObjectModel.collectionToString(col);
    }

    @Deprecated
    protected Collection<Object> fromIterator(Iterator<Object> iterator) {
        return ObjectModel.fromIterator(iterator);
    }

    @Deprecated
    protected boolean toBooleanInternal(Object obj) {
        return ObjectModel.toBoolean((Object)obj);
    }

    @Deprecated
    protected Object getIndex(Object obj, int index) {
        return ObjectModel.getIndex((Object)obj, (int)index);
    }

    @Deprecated
    protected Object getIndexSafe(List list, int index) {
        return ObjectModel.getIndex((Object)list, (int)index);
    }

    @Deprecated
    protected Object getMapProperty(Map map, String property) {
        return map.get(property);
    }

    @Deprecated
    protected Object getObjectProperty(Object obj, String property) {
        return ObjectModel.resolveProperty((Object)obj, (Object)property);
    }

    @Deprecated
    protected static Object getField(Object obj, String property) {
        return ObjectModel.getField((Object)obj, (String)property);
    }

    @Deprecated
    protected Object getObjectNoArgMethod(Object obj, String property) {
        return ObjectModel.invokeBeanMethod((Object)obj, (String)property);
    }

    @Deprecated
    protected static Method findMethod(Class<?> cls, String baseName) {
        return ObjectModel.findBeanMethod(cls, (String)baseName);
    }

    @Deprecated
    protected static boolean isMethodAllowed(Method method) {
        return ObjectModel.isMethodAllowed((Method)method);
    }

    @Deprecated
    protected Method extractMethodInheritanceChain(Class type, Method m) {
        return ObjectModel.findBeanMethod((Class)type, (String)m.getName());
    }

    @Deprecated
    protected Method getClassMethod(Class<?> clazz, Method m) {
        return ObjectModel.findBeanMethod(clazz, (String)m.getName());
    }
}

