/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl;

public class JavaClassTemplate {
    private String classTemplate;
    private static final String PACKAGE_NAME = "PackageName";
    private static final String IMPORTS = "Imports";
    private static final String CLASS_NAME = "ClassName";
    private static final String MAIN_BODY = "MainBody";
    private static final String TEMPLATE_INIT = "SubTemplateMapInit";
    private static final String NAME = "Name";
    private StringBuilder templateInitBuilder = new StringBuilder();

    public JavaClassTemplate(String template) {
        this.classTemplate = template;
    }

    public void writeMainBody(String content) {
        this.setPart(MAIN_BODY, content);
    }

    public void writeSubTemplate(String name, String content) {
        this.templateInitBuilder.append(this.insertPart(NAME, content, name));
    }

    public void setClassName(String name) {
        this.setPart(CLASS_NAME, name);
    }

    public void setPackageName(String name) {
        this.setPart(PACKAGE_NAME, name);
    }

    public void setImports(String imports) {
        this.setPart(IMPORTS, imports);
    }

    public String toString() {
        return this.insertPart(TEMPLATE_INIT, this.classTemplate, this.templateInitBuilder.toString());
    }

    private void setPart(String partName, String content) {
        this.classTemplate = this.insertPart(partName, this.classTemplate, content);
    }

    private String insertPart(String partName, String original, String content) {
        String id = "##" + partName + "##";
        return original.replace(id, content);
    }
}

