/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl.operator;

import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.SideEffectVisitor;
import org.apache.sling.scripting.sightly.java.compiler.impl.ExpressionTranslator;
import org.apache.sling.scripting.sightly.java.compiler.impl.JavaSource;
import org.apache.sling.scripting.sightly.java.compiler.impl.Type;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.OpHelper;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.TypedNode;

public class EquivalenceOpGen
implements BinaryOpGen {
    private final boolean negated;

    public EquivalenceOpGen(boolean negated) {
        this.negated = negated;
    }

    @Override
    public Type returnType(Type left, Type right) {
        return Type.BOOLEAN;
    }

    @Override
    public void generate(JavaSource source, ExpressionTranslator visitor, TypedNode left, TypedNode right) {
        Type type = OpHelper.sameType(left, right);
        if (type != null && OpHelper.isNumericType(type) || type == Type.BOOLEAN || type == Type.UNKNOWN) {
            this.generateEqualsOperator(source, visitor, left.getNode(), right.getNode());
        } else if (type != Type.UNKNOWN) {
            this.generateEqualsMethod(source, visitor, left, right);
        }
    }

    private void generateCheckedEquals(JavaSource source, SideEffectVisitor visitor, TypedNode leftNode, TypedNode rightNode) {
        source.startExpression();
        leftNode.getNode().accept((NodeVisitor)visitor);
        source.equality().nullLiteral().conditional();
        rightNode.getNode().accept((NodeVisitor)visitor);
        source.equality().nullLiteral();
        source.conditionalBranchSep();
        this.generateEqualsMethod(source, visitor, leftNode, rightNode);
        source.endExpression();
    }

    private void generateEqualsMethod(JavaSource source, SideEffectVisitor visitor, TypedNode leftNode, TypedNode rightNode) {
        boolean performCast = leftNode.getType().isPrimitive();
        if (performCast) {
            source.startExpression();
            source.cast(Type.UNKNOWN.getNativeClass());
        }
        leftNode.getNode().accept((NodeVisitor)visitor);
        if (performCast) {
            source.endExpression();
        }
        source.startCall("equals", true);
        rightNode.getNode().accept((NodeVisitor)visitor);
        source.endCall();
    }

    private void generateEqualsOperator(JavaSource source, SideEffectVisitor visitor, ExpressionNode leftNode, ExpressionNode rightNode) {
        leftNode.accept((NodeVisitor)visitor);
        source.append(this.operator());
        rightNode.accept((NodeVisitor)visitor);
    }

    private String operator() {
        return this.negated ? "!=" : "==";
    }
}

