/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import org.apache.sling.scripting.sightly.compiler.SightlyCompilerException;
import org.apache.sling.scripting.sightly.compiler.commands.Procedure;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.Patterns;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.plugin.AbstractPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class CallPlugin
extends AbstractPlugin {
    public CallPlugin() {
        this.name = "call";
        this.priority = 3;
    }

    @Override
    public PluginInvoke invoke(final Expression expression, PluginCallInfo callInfo, final CompilerContext compilerContext) {
        if (callInfo.getArguments().length > 0) {
            throw new SightlyCompilerException("Call plugin should have no arguments.", "data-sly-call." + callInfo.getArguments()[0]);
        }
        return new DefaultPluginInvoke(){

            @Override
            public void beforeChildren(PushStream stream) {
                String templateVar = compilerContext.generateVariable("templateVar");
                String argsVar = compilerContext.generateVariable("templateOptions");
                MapLiteral args = new MapLiteral(expression.getOptions());
                stream.write(new VariableBinding.Start(templateVar, expression.getRoot()));
                stream.write(new VariableBinding.Start(argsVar, args));
                stream.write(new Procedure.Call(templateVar, argsVar));
                stream.write(VariableBinding.END);
                stream.write(VariableBinding.END);
                Patterns.beginStreamIgnore(stream);
            }

            @Override
            public void afterChildren(PushStream stream) {
                Patterns.endStreamIgnore(stream);
            }
        };
    }
}

