/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.Loop;
import org.apache.sling.scripting.sightly.compiler.commands.OutText;
import org.apache.sling.scripting.sightly.compiler.commands.OutputVariable;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.MarkupContext;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BooleanConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Identifier;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.PropertyAccess;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;
import org.apache.sling.scripting.sightly.impl.compiler.Patterns;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;
import org.apache.sling.scripting.sightly.impl.html.MarkupUtils;
import org.apache.sling.scripting.sightly.impl.plugin.AbstractPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class AttributePlugin
extends AbstractPlugin {
    public AttributePlugin() {
        this.name = "attribute";
        this.priority = 150;
    }

    @Override
    public PluginInvoke invoke(Expression expression, PluginCallInfo callInfo, CompilerContext compilerContext) {
        String attributeName = this.decodeAttributeName(callInfo);
        if (attributeName != null && MarkupUtils.isSensitiveAttribute(attributeName)) {
            String warningMessage = String.format("Sensible attribute (%s) detected: event attributes (on*) and the style attribute cannot be generated with the data-sly-attribute block element; if you need to output a dynamic value for this attribute then use an expression with an appropriate context.", attributeName);
            compilerContext.getPushStream().warn(new PushStream.StreamMessage(warningMessage, expression.getRawText()));
            return new DefaultPluginInvoke();
        }
        return attributeName != null ? new SingleAttributeInvoke(attributeName, expression, compilerContext) : new MultiAttributeInvoke(expression.getRoot(), compilerContext);
    }

    private String decodeAttributeName(PluginCallInfo info) {
        Object[] arguments = info.getArguments();
        if (arguments.length == 0) {
            return null;
        }
        return StringUtils.join((Object[])arguments, (char)'-');
    }

    private static ExpressionNode escapeNodeWithHint(CompilerContext compilerContext, ExpressionNode node, MarkupContext markupContext, ExpressionNode hint) {
        if (hint != null) {
            return new RuntimeCall("xss", node, new StringConstant(markupContext.getName()), hint);
        }
        return compilerContext.adjustToContext(new Expression(node), markupContext, ExpressionContext.ATTRIBUTE).getRoot();
    }

    private final class MultiAttributeInvoke
    extends DefaultPluginInvoke {
        private final ExpressionNode attrMap;
        private final String attrMapVar;
        private final CompilerContext compilerContext;
        private boolean beforeCall = true;
        private final Set<String> ignored = new HashSet<String>();

        private MultiAttributeInvoke(ExpressionNode attrMap, CompilerContext context) {
            this.attrMap = attrMap;
            this.compilerContext = context;
            this.attrMapVar = context.generateVariable("attrMap");
        }

        @Override
        public void beforeAttributes(PushStream stream) {
            stream.write(new VariableBinding.Start(this.attrMapVar, this.attrMap));
        }

        @Override
        public void beforeAttribute(PushStream stream, String attributeName) {
            this.ignored.add(attributeName);
            if (this.beforeCall) {
                String attrNameVar = this.compilerContext.generateVariable("attrName_" + attributeName);
                String attrValue = this.compilerContext.generateVariable("mapContains_" + attributeName);
                stream.write(new VariableBinding.Start(attrNameVar, new StringConstant(attributeName)));
                stream.write(new VariableBinding.Start(attrValue, this.attributeValueNode(new StringConstant(attributeName))));
                this.writeAttribute(stream, attrNameVar, attrValue);
                stream.write(new Conditional.Start(attrValue, false));
            }
        }

        @Override
        public void afterAttribute(PushStream stream, String attributeName) {
            if (this.beforeCall) {
                stream.write(Conditional.END);
                stream.write(VariableBinding.END);
                stream.write(VariableBinding.END);
            }
        }

        @Override
        public void onPluginCall(PushStream stream, PluginCallInfo callInfo, Expression expression) {
            if ("attribute".equals(callInfo.getName())) {
                String attrName = AttributePlugin.this.decodeAttributeName(callInfo);
                if (attrName == null) {
                    this.beforeCall = false;
                } else if (!this.beforeCall) {
                    this.ignored.add(attrName);
                }
            }
        }

        @Override
        public void afterAttributes(PushStream stream) {
            HashMap<String, ExpressionNode> ignoredLiteralMap = new HashMap<String, ExpressionNode>();
            for (String attr : this.ignored) {
                ignoredLiteralMap.put(attr, new BooleanConstant(true));
            }
            MapLiteral ignoredLiteral = new MapLiteral(ignoredLiteralMap);
            String ignoredVar = this.compilerContext.generateVariable("ignoredAttributes");
            stream.write(new VariableBinding.Start(ignoredVar, ignoredLiteral));
            String attrNameVar = this.compilerContext.generateVariable("attrName");
            String attrNameEscaped = this.compilerContext.generateVariable("attrNameEscaped");
            String attrIndex = this.compilerContext.generateVariable("attrIndex");
            stream.write(new Loop.Start(this.attrMapVar, attrNameVar, attrIndex));
            stream.write(new VariableBinding.Start(attrNameEscaped, this.escapeNode(new Identifier(attrNameVar), MarkupContext.ATTRIBUTE_NAME, null)));
            stream.write(new Conditional.Start(attrNameEscaped, true));
            String isIgnoredAttr = this.compilerContext.generateVariable("isIgnoredAttr");
            stream.write(new VariableBinding.Start(isIgnoredAttr, new PropertyAccess((ExpressionNode)new Identifier(ignoredVar), new Identifier(attrNameVar))));
            stream.write(new Conditional.Start(isIgnoredAttr, false));
            String attrContent = this.compilerContext.generateVariable("attrContent");
            stream.write(new VariableBinding.Start(attrContent, this.attributeValueNode(new Identifier(attrNameVar))));
            this.writeAttribute(stream, attrNameEscaped, attrContent);
            stream.write(VariableBinding.END);
            stream.write(Conditional.END);
            stream.write(VariableBinding.END);
            stream.write(Conditional.END);
            stream.write(VariableBinding.END);
            stream.write(Loop.END);
            stream.write(VariableBinding.END);
            stream.write(VariableBinding.END);
        }

        private void writeAttribute(PushStream stream, String attrNameVar, String attrContentVar) {
            String escapedContent = this.compilerContext.generateVariable("attrContentEscaped");
            String shouldDisplayAttribute = this.compilerContext.generateVariable("shouldDisplayAttr");
            stream.write(new VariableBinding.Start(escapedContent, this.escapedExpression(new Identifier(attrContentVar), new Identifier(attrNameVar))));
            stream.write(new VariableBinding.Start(shouldDisplayAttribute, new BinaryOperation(BinaryOperator.OR, new Identifier(escapedContent), new BinaryOperation(BinaryOperator.EQ, new StringConstant("false"), new Identifier(attrContentVar)))));
            stream.write(new Conditional.Start(shouldDisplayAttribute, true));
            stream.write(new OutText(" "));
            this.writeAttributeName(stream, attrNameVar);
            this.writeAttributeValue(stream, escapedContent, attrContentVar);
            stream.write(Conditional.END);
            stream.write(VariableBinding.END);
            stream.write(VariableBinding.END);
        }

        private void writeAttributeName(PushStream stream, String attrNameVar) {
            stream.write(new OutputVariable(attrNameVar));
        }

        private void writeAttributeValue(PushStream stream, String escapedContent, String attrContentVar) {
            String isTrueVar = this.compilerContext.generateVariable("isTrueAttr");
            stream.write(new VariableBinding.Start(isTrueVar, new BinaryOperation(BinaryOperator.EQ, new Identifier(attrContentVar), BooleanConstant.TRUE)));
            stream.write(new Conditional.Start(isTrueVar, false));
            stream.write(new OutText("=\""));
            stream.write(new OutputVariable(escapedContent));
            stream.write(new OutText("\""));
            stream.write(Conditional.END);
            stream.write(VariableBinding.END);
        }

        private ExpressionNode attributeValueNode(ExpressionNode attributeNameNode) {
            return new PropertyAccess((ExpressionNode)new Identifier(this.attrMapVar), attributeNameNode);
        }

        private ExpressionNode escapedExpression(ExpressionNode original, ExpressionNode hint) {
            return this.escapeNode(original, MarkupContext.ATTRIBUTE, hint);
        }

        private ExpressionNode escapeNode(ExpressionNode node, MarkupContext markupContext, ExpressionNode hint) {
            return AttributePlugin.escapeNodeWithHint(this.compilerContext, node, markupContext, hint);
        }
    }

    private final class SingleAttributeInvoke
    extends DefaultPluginInvoke {
        private final String attributeName;
        private final String isTrueValue;
        private final String escapedAttrValue;
        private final String shouldDisplayAttribute;
        private boolean writeAtEnd = true;
        private boolean beforeCall = true;
        private final String attrValue;
        private final ExpressionNode node;
        private final ExpressionNode contentNode;

        private SingleAttributeInvoke(String attributeName, Expression expression, CompilerContext compilerContext) {
            this.attributeName = attributeName;
            this.attrValue = compilerContext.generateVariable("attrValue_" + attributeName);
            this.escapedAttrValue = compilerContext.generateVariable("attrValueEscaped_" + attributeName);
            this.isTrueValue = compilerContext.generateVariable("isTrueValue_" + attributeName);
            this.shouldDisplayAttribute = compilerContext.generateVariable("shouldDisplayAttr_" + attributeName);
            this.node = expression.getRoot();
            this.contentNode = !expression.containsOption("context") ? AttributePlugin.escapeNodeWithHint(compilerContext, new Identifier(this.attrValue), MarkupContext.ATTRIBUTE, new StringConstant(attributeName)) : new Identifier(this.attrValue);
        }

        @Override
        public void beforeAttribute(PushStream stream, String attributeName) {
            if (attributeName.equals(this.attributeName)) {
                if (this.beforeCall) {
                    this.emitStart(stream);
                }
                this.writeAtEnd = false;
            }
        }

        @Override
        public void beforeAttributeValue(PushStream stream, String attributeName, ExpressionNode attributeValue) {
            if (attributeName.equals(this.attributeName) && this.beforeCall) {
                this.emitWrite(stream);
                Patterns.beginStreamIgnore(stream);
            }
        }

        @Override
        public void afterAttributeValue(PushStream stream, String attributeName) {
            if (attributeName.equals(this.attributeName) && this.beforeCall) {
                Patterns.endStreamIgnore(stream);
            }
        }

        @Override
        public void afterAttribute(PushStream stream, String attributeName) {
            if (attributeName.equals(this.attributeName) && this.beforeCall) {
                this.emitEnd(stream);
            }
        }

        @Override
        public void afterAttributes(PushStream stream) {
            if (this.writeAtEnd) {
                this.emitStart(stream);
                stream.write(new OutText(" " + this.attributeName));
                this.emitWrite(stream);
                this.emitEnd(stream);
            }
        }

        @Override
        public void onPluginCall(PushStream stream, PluginCallInfo callInfo, Expression expression) {
            String attributeName;
            if ("attribute".equals(callInfo.getName()) && this.attributeName.equals(attributeName = AttributePlugin.this.decodeAttributeName(callInfo))) {
                this.beforeCall = false;
            }
        }

        private void emitStart(PushStream stream) {
            stream.write(new VariableBinding.Start(this.attrValue, this.node));
            stream.write(new VariableBinding.Start(this.escapedAttrValue, this.contentNode));
            stream.write(new VariableBinding.Start(this.shouldDisplayAttribute, new BinaryOperation(BinaryOperator.OR, new Identifier(this.escapedAttrValue), new BinaryOperation(BinaryOperator.EQ, new StringConstant("false"), new Identifier(this.attrValue)))));
            stream.write(new Conditional.Start(this.shouldDisplayAttribute, true));
        }

        private void emitWrite(PushStream stream) {
            stream.write(new VariableBinding.Start(this.isTrueValue, new BinaryOperation(BinaryOperator.EQ, new Identifier(this.attrValue), BooleanConstant.TRUE)));
            stream.write(new Conditional.Start(this.isTrueValue, false));
            stream.write(new OutText("=\""));
            stream.write(new OutputVariable(this.escapedAttrValue));
            stream.write(new OutText("\""));
            stream.write(Conditional.END);
            stream.write(VariableBinding.END);
        }

        private void emitEnd(PushStream stream) {
            stream.write(Conditional.END);
            stream.write(VariableBinding.END);
            stream.write(VariableBinding.END);
            stream.write(VariableBinding.END);
        }
    }
}

