/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import java.util.Map;
import java.util.Set;
import org.apache.sling.scripting.sightly.compiler.SightlyCompilerException;
import org.apache.sling.scripting.sightly.compiler.commands.Procedure;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.Patterns;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.plugin.AbstractPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class TemplatePlugin
extends AbstractPlugin {
    public TemplatePlugin() {
        this.name = "template";
        this.priority = Integer.MIN_VALUE;
    }

    @Override
    public PluginInvoke invoke(final Expression expressionNode, final PluginCallInfo callInfo, CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){

            @Override
            public void beforeTagOpen(PushStream stream) {
                Patterns.beginStreamIgnore(stream);
            }

            @Override
            public void beforeElement(PushStream stream, String tagName) {
                String name = this.decodeName();
                Set<String> parameters = this.extractParameters();
                stream.write(new Procedure.Start(name, parameters));
            }

            @Override
            public void afterElement(PushStream stream) {
                stream.write(Procedure.END);
            }

            @Override
            public void afterTagOpen(PushStream stream) {
                Patterns.endStreamIgnore(stream);
            }

            @Override
            public void beforeTagClose(PushStream stream, boolean isSelfClosing) {
                Patterns.beginStreamIgnore(stream);
            }

            @Override
            public void afterTagClose(PushStream stream, boolean isSelfClosing) {
                Patterns.endStreamIgnore(stream);
            }

            private Set<String> extractParameters() {
                Map<String, ExpressionNode> options = expressionNode.getOptions();
                return options.keySet();
            }

            private String decodeName() {
                String[] arguments = callInfo.getArguments();
                if (arguments.length == 0) {
                    throw new SightlyCompilerException("Template name was not provided.", "data-sly-template=");
                }
                return arguments[0];
            }
        };
    }
}

