/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import java.util.HashMap;
import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.Loop;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Identifier;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NumericConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.UnaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.UnaryOperator;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.Syntax;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.plugin.AbstractPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class ListPlugin
extends AbstractPlugin {
    private static final String INDEX = "index";
    private static final String COUNT = "count";
    private static final String FIRST = "first";
    private static final String MIDDLE = "middle";
    private static final String LAST = "last";
    private static final String ODD = "odd";
    private static final String EVEN = "even";

    public ListPlugin() {
        this.name = "list";
        this.priority = 130;
    }

    @Override
    public PluginInvoke invoke(final Expression expression, final PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){
            private String listVariable;
            private String collectionSizeVar;
            {
                this.listVariable = compilerContext.generateVariable("collectionVar");
                this.collectionSizeVar = compilerContext.generateVariable("size");
            }

            @Override
            public void beforeElement(PushStream stream, String tagName) {
                stream.write(new VariableBinding.Start(this.listVariable, expression.getRoot()));
                stream.write(new VariableBinding.Start(this.collectionSizeVar, new UnaryOperation(UnaryOperator.LENGTH, new Identifier(this.listVariable))));
                stream.write(new Conditional.Start(this.collectionSizeVar, true));
            }

            @Override
            public void beforeChildren(PushStream stream) {
                String itemVariable = this.decodeItemVariable();
                String loopStatusVar = Syntax.itemLoopStatusVariable(itemVariable);
                String indexVariable = compilerContext.generateVariable(ListPlugin.INDEX);
                stream.write(new Loop.Start(this.listVariable, itemVariable, indexVariable));
                stream.write(new VariableBinding.Start(loopStatusVar, this.buildStatusObj(indexVariable, this.collectionSizeVar)));
            }

            @Override
            public void afterChildren(PushStream stream) {
                stream.write(VariableBinding.END);
                stream.write(Loop.END);
            }

            @Override
            public void afterElement(PushStream stream) {
                stream.write(Conditional.END);
                stream.write(VariableBinding.END);
                stream.write(VariableBinding.END);
            }

            private String decodeItemVariable() {
                String[] args = callInfo.getArguments();
                if (args.length > 0) {
                    return args[0];
                }
                return "item";
            }

            private MapLiteral buildStatusObj(String indexVar, String sizeVar) {
                HashMap<String, ExpressionNode> obj = new HashMap<String, ExpressionNode>();
                Identifier indexId = new Identifier(indexVar);
                BinaryOperation firstExpr = new BinaryOperation(BinaryOperator.EQ, indexId, NumericConstant.ZERO);
                BinaryOperation lastExpr = new BinaryOperation(BinaryOperator.EQ, indexId, new BinaryOperation(BinaryOperator.SUB, new Identifier(sizeVar), NumericConstant.ONE));
                obj.put(ListPlugin.INDEX, indexId);
                obj.put(ListPlugin.COUNT, new BinaryOperation(BinaryOperator.ADD, indexId, NumericConstant.ONE));
                obj.put(ListPlugin.FIRST, firstExpr);
                obj.put(ListPlugin.MIDDLE, new UnaryOperation(UnaryOperator.NOT, new BinaryOperation(BinaryOperator.OR, firstExpr, lastExpr)));
                obj.put(ListPlugin.LAST, lastExpr);
                obj.put(ListPlugin.ODD, this.parityCheck(indexId, NumericConstant.ZERO));
                obj.put(ListPlugin.EVEN, this.parityCheck(indexId, NumericConstant.ONE));
                return new MapLiteral(obj);
            }

            private ExpressionNode parityCheck(ExpressionNode numericExpression, NumericConstant expected) {
                return new BinaryOperation(BinaryOperator.EQ, new BinaryOperation(BinaryOperator.REM, numericExpression, NumericConstant.TWO), expected);
            }
        };
    }
}

