/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.optimization;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.scripting.sightly.compiler.commands.Command;
import org.apache.sling.scripting.sightly.compiler.commands.CommandStream;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Identifier;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NullLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.PropertyAccess;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.StreamTransformer;
import org.apache.sling.scripting.sightly.impl.compiler.util.expression.NodeTransformer;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.EmitterVisitor;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.Streams;
import org.apache.sling.scripting.sightly.impl.compiler.visitor.TrackingVisitor;

public final class SyntheticMapRemoval
extends TrackingVisitor<MapLiteral>
implements EmitterVisitor {
    public static final StreamTransformer TRANSFORMER = new StreamTransformer(){

        @Override
        public CommandStream transform(CommandStream inStream) {
            return Streams.map(inStream, new SyntheticMapRemoval());
        }
    };
    private static final String VARIABLE_MARKER = "_field$_";
    private final PushStream outputStream = new PushStream();
    private final NodeTransformer transformer = new PropertyAccessTransformer();

    private SyntheticMapRemoval() {
    }

    @Override
    public void visit(VariableBinding.Start variableBindingStart) {
        ExpressionNode node = variableBindingStart.getExpression();
        String variable = variableBindingStart.getVariableName();
        ExpressionNode transformed = this.transform(node);
        if (transformed instanceof MapLiteral) {
            MapLiteral newLiteral = this.overrideMap(variable, (MapLiteral)transformed);
            this.tracker.pushVariable(variable, newLiteral);
            transformed = newLiteral;
        } else {
            this.tracker.pushVariable(variable, null);
        }
        this.outputStream.write(new VariableBinding.Start(variable, transformed));
    }

    @Override
    public void visit(VariableBinding.End variableBindingEnd) {
        Map.Entry entry = this.tracker.peek();
        super.visit(variableBindingEnd);
        MapLiteral literal = (MapLiteral)entry.getValue();
        if (literal != null) {
            for (int i = 0; i < literal.getMap().size(); ++i) {
                this.outputStream.write(VariableBinding.END);
            }
        }
    }

    private ExpressionNode transform(ExpressionNode node) {
        return this.transformer.transform(node);
    }

    private MapLiteral overrideMap(String variableName, MapLiteral mapLiteral) {
        HashMap<String, ExpressionNode> newLiteral = new HashMap<String, ExpressionNode>();
        for (Map.Entry<String, ExpressionNode> entry : mapLiteral.getMap().entrySet()) {
            String property = entry.getKey();
            ExpressionNode valueNode = entry.getValue();
            String valueVariable = this.valueVariableName(variableName, property);
            newLiteral.put(property, new Identifier(valueVariable));
            this.outputStream.write(new VariableBinding.Start(valueVariable, valueNode));
        }
        return new MapLiteral(newLiteral);
    }

    private String valueVariableName(String variableName, String propertyName) {
        return variableName + VARIABLE_MARKER + propertyName;
    }

    @Override
    protected MapLiteral assignDefault(Command command) {
        return null;
    }

    @Override
    public void onCommand(Command command) {
        this.outputStream.write(command);
    }

    @Override
    public PushStream getOutputStream() {
        return this.outputStream;
    }

    private class PropertyAccessTransformer
    extends NodeTransformer {
        private PropertyAccessTransformer() {
        }

        @Override
        public ExpressionNode evaluate(PropertyAccess propertyAccess) {
            String property;
            MapLiteral literal;
            ExpressionNode target = propertyAccess.getTarget();
            String variable = this.extractIdentifier(target);
            if (variable != null && (literal = (MapLiteral)SyntheticMapRemoval.this.tracker.get(variable)) != null && (property = this.extractProperty(propertyAccess.getProperty())) != null) {
                ExpressionNode replacementNode = literal.getValue(property);
                if (replacementNode == null) {
                    replacementNode = NullLiteral.INSTANCE;
                }
                return replacementNode;
            }
            return super.evaluate(propertyAccess);
        }

        private String extractProperty(ExpressionNode expressionNode) {
            if (expressionNode instanceof StringConstant) {
                return ((StringConstant)expressionNode).getText();
            }
            return null;
        }

        private String extractIdentifier(ExpressionNode node) {
            if (node instanceof Identifier) {
                return ((Identifier)node).getName();
            }
            return null;
        }
    }
}

