/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.optimization;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.sling.scripting.sightly.compiler.commands.Command;
import org.apache.sling.scripting.sightly.compiler.commands.CommandStream;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.CommandVariableUsage;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.StreamTransformer;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.EmitterVisitor;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.Streams;
import org.apache.sling.scripting.sightly.impl.compiler.visitor.TrackingVisitor;

public final class UnusedVariableRemoval
extends TrackingVisitor<VariableActivity>
implements EmitterVisitor {
    public static final StreamTransformer TRANSFORMER = new StreamTransformer(){

        @Override
        public CommandStream transform(CommandStream inStream) {
            return Streams.map(inStream, new UnusedVariableRemoval());
        }
    };
    private final PushStream outputStream = new PushStream();
    private final Stack<List<Command>> storedCommandsStack = new Stack();

    private UnusedVariableRemoval() {
    }

    @Override
    public PushStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void visit(VariableBinding.Start variableBindingStart) {
        this.storedCommandsStack.push(new ArrayList());
        this.tracker.pushVariable(variableBindingStart.getVariableName(), new VariableActivity(variableBindingStart));
    }

    @Override
    public void visit(VariableBinding.End variableBindingEnd) {
        VariableActivity variableActivity = (VariableActivity)this.tracker.peek().getValue();
        this.tracker.popVariable();
        boolean emitBindingEnd = true;
        if (variableActivity != null) {
            List<Command> commands = this.storedCommandsStack.pop();
            emitBindingEnd = variableActivity.isUsed();
            if (variableActivity.isUsed()) {
                VariableBinding.Start variableBindingStart = variableActivity.getCommand();
                this.emit(variableBindingStart);
                this.registerUsage(variableBindingStart);
            }
            for (Command command : commands) {
                this.emit(command);
            }
        }
        if (emitBindingEnd) {
            this.emit(variableBindingEnd);
        }
    }

    @Override
    protected VariableActivity assignDefault(Command command) {
        return null;
    }

    @Override
    protected void onCommand(Command command) {
        this.registerUsage(command);
        this.emit(command);
    }

    private void emit(Command command) {
        if (this.storedCommandsStack.isEmpty()) {
            this.outputStream.write(command);
        } else {
            List<Command> list = this.storedCommandsStack.peek();
            list.add(command);
        }
    }

    private void registerUsage(Command command) {
        List<String> usedVariables = CommandVariableUsage.extractVariables(command);
        for (String usedVariable : usedVariables) {
            VariableActivity activity = (VariableActivity)this.tracker.get(usedVariable);
            if (activity == null) continue;
            activity.markUsed();
        }
    }

    static class VariableActivity {
        private boolean used;
        private VariableBinding.Start command;

        VariableActivity(VariableBinding.Start command) {
            this.command = command;
        }

        public void markUsed() {
            this.used = true;
        }

        public boolean isUsed() {
            return this.used;
        }

        public VariableBinding.Start getCommand() {
            return this.command;
        }
    }
}

