/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.rhino;

import java.util.HashSet;
import java.util.Set;
import org.apache.sling.scripting.sightly.Record;
import org.apache.sling.scripting.sightly.js.impl.rhino.JsUtils;
import org.apache.sling.scripting.sightly.js.impl.rhino.JsValueAdapter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class HybridObject
implements Scriptable,
Record<Object> {
    private final Scriptable scriptable;
    private final JsValueAdapter jsValueAdapter;

    public HybridObject(Scriptable scriptable, JsValueAdapter jsValueAdapter) {
        this.scriptable = scriptable;
        this.jsValueAdapter = jsValueAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String name) {
        if (name == null) {
            return null;
        }
        Context.enter();
        try {
            Object object = this.getAdapted(name);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    public Set<String> getPropertyNames() {
        Object[] properties = this.scriptable.getIds();
        HashSet<String> keys = new HashSet<String>();
        for (Object property : properties) {
            if (!(property instanceof String)) continue;
            keys.add((String)property);
        }
        return keys;
    }

    private Object getAdapted(String key) {
        Object obj = ScriptableObject.getProperty((Scriptable)this.scriptable, (String)key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Function) {
            return this.jsValueAdapter.adapt(JsUtils.callFn((Function)obj, null, this.scriptable, this.scriptable, new Object[0]));
        }
        return this.jsValueAdapter.adapt(obj);
    }

    public String getClassName() {
        return this.scriptable.getClassName();
    }

    public Object get(String name, Scriptable start) {
        return this.scriptable.get(name, start);
    }

    public Object get(int index, Scriptable start) {
        return this.scriptable.get(index, start);
    }

    public boolean has(String name, Scriptable start) {
        return this.scriptable.has(name, start);
    }

    public boolean has(int index, Scriptable start) {
        return this.scriptable.has(index, start);
    }

    public void put(String name, Scriptable start, Object value) {
        this.scriptable.put(name, start, value);
    }

    public void put(int index, Scriptable start, Object value) {
        this.scriptable.put(index, start, value);
    }

    public void delete(String name) {
        this.scriptable.delete(name);
    }

    public void delete(int index) {
        this.scriptable.delete(index);
    }

    public Scriptable getPrototype() {
        return this.scriptable.getPrototype();
    }

    public void setPrototype(Scriptable prototype) {
        this.scriptable.setPrototype(prototype);
    }

    public Scriptable getParentScope() {
        return this.scriptable.getParentScope();
    }

    public void setParentScope(Scriptable parent) {
        this.scriptable.setParentScope(parent);
    }

    public Object[] getIds() {
        return this.scriptable.getIds();
    }

    public Object getDefaultValue(Class hint) {
        return this.scriptable.getDefaultValue(hint);
    }

    public boolean hasInstance(Scriptable instance) {
        return this.scriptable.hasInstance(instance);
    }
}

