/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.jsapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.scripting.sightly.js.impl.JsEnvironment;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncContainer;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncExtractor;
import org.apache.sling.scripting.sightly.js.impl.async.TimingBindingsValuesProvider;
import org.apache.sling.scripting.sightly.js.impl.async.TimingFunction;
import org.apache.sling.scripting.sightly.js.impl.cjs.CommonJsModule;
import org.apache.sling.scripting.sightly.js.impl.rhino.HybridObject;
import org.apache.sling.scripting.sightly.js.impl.rhino.JsValueAdapter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Sling Scripting Sightly JavaScript Bindings Provider", description="The Apache Sling Scripting Sightly JavaScript Bindings Provider loads the JS Use-API and makes it available in the bindings map.")
@Service(value={SlyBindingsValuesProvider.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.js.bindings", value={"sightly:/libs/sling/sightly/js/internal/sly.js"}, unbounded=PropertyUnbounded.ARRAY, label="Script Factories", description="Script factories to load in the bindings map. The entries should be in the form 'namespace:/path/from/repository'.")})
public class SlyBindingsValuesProvider {
    public static final String SCR_PROP_JS_BINDING_IMPLEMENTATIONS = "org.apache.sling.scripting.sightly.js.bindings";
    public static final String SLING_NS_PATH = "/libs/sling/sightly/js/internal/sly.js";
    public static final String Q_PATH = "/libs/sling/sightly/js/3rd-party/q.js";
    private static final String REQ_NS = SlyBindingsValuesProvider.class.getCanonicalName();
    private static final Logger log = LoggerFactory.getLogger(SlyBindingsValuesProvider.class);
    @Reference
    private ScriptEngineManager scriptEngineManager;
    @Reference
    private ResourceResolverFactory rrf = null;
    private final AsyncExtractor asyncExtractor = new AsyncExtractor();
    private final JsValueAdapter jsValueAdapter = new JsValueAdapter(this.asyncExtractor);
    private Map<String, String> scriptPaths = new HashMap<String, String>();
    private Map<String, Function> factories = new HashMap<String, Function>();
    private Script qScript;
    private final ScriptableObject qScope = this.createQScope();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBindings(Bindings bindings) {
        if (this.needsInit()) {
            this.init(bindings);
        }
        Context context = null;
        try {
            context = Context.enter();
            Object qInstance = this.obtainQInstance(context, bindings);
            if (qInstance == null) {
                return;
            }
            for (Map.Entry<String, Function> entry : this.factories.entrySet()) {
                this.addBinding(context, entry.getValue(), bindings, entry.getKey(), qInstance);
            }
        }
        finally {
            if (context != null) {
                Context.exit();
            }
        }
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        String[] factories = PropertiesUtil.toStringArray(properties.get(SCR_PROP_JS_BINDING_IMPLEMENTATIONS), (String[])new String[]{SLING_NS_PATH});
        this.scriptPaths = new HashMap<String, String>(factories.length);
        for (String f : factories) {
            String[] parts = f.split(":");
            if (parts.length != 2) continue;
            this.scriptPaths.put(parts[0], parts[1]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        if (this.scriptPaths != null) {
            this.scriptPaths.clear();
        }
        if (this.factories != null) {
            this.factories.clear();
        }
    }

    private void addBinding(Context context, Function factory, Bindings bindings, String globalName, Object qInstance) {
        if (factory == null) {
            return;
        }
        Object result = factory.call(context, (Scriptable)factory, (Scriptable)factory, new Object[]{bindings, qInstance});
        HybridObject global = new HybridObject((Scriptable)result, this.jsValueAdapter);
        bindings.put(globalName, (Object)global);
    }

    private boolean needsInit() {
        return this.factories == null || this.factories.isEmpty() || this.qScript == null;
    }

    private synchronized void init(Bindings bindings) {
        if (this.needsInit()) {
            this.ensureFactoriesLoaded(bindings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFactoriesLoaded(Bindings bindings) {
        JsEnvironment jsEnvironment = null;
        try {
            ScriptEngine scriptEngine = this.obtainEngine();
            if (scriptEngine == null) {
                return;
            }
            jsEnvironment = new JsEnvironment(scriptEngine);
            jsEnvironment.initialize();
            this.factories = new HashMap<String, Function>(this.scriptPaths.size());
            for (Map.Entry<String, String> entry : this.scriptPaths.entrySet()) {
                this.factories.put(entry.getKey(), this.loadFactory(jsEnvironment, entry.getValue(), bindings));
            }
            this.qScript = this.loadQScript();
        }
        finally {
            if (jsEnvironment != null) {
                jsEnvironment.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Function loadFactory(JsEnvironment jsEnvironment, String path, Bindings bindings) {
        ResourceResolver resolver = null;
        try {
            resolver = this.rrf.getAdministrativeResourceResolver(null);
            Resource resource = resolver.getResource(path);
            if (resource == null) {
                log.warn("Sly namespace loader could not find the following script: " + path);
                Function function = null;
                return function;
            }
            AsyncContainer container = jsEnvironment.runResource(resource, this.createBindings(bindings), new SimpleBindings());
            Object obj = container.getResult();
            if (!(obj instanceof Function)) {
                log.warn("Script was expected to return a function");
                Function function = null;
                return function;
            }
            Function function = (Function)obj;
            return function;
        }
        catch (LoginException e) {
            log.error("Cannot evaluate script " + path, (Throwable)e);
            Function function = null;
            return function;
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    private Bindings createBindings(Bindings global) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.putAll(global);
        TimingBindingsValuesProvider.INSTANCE.addBindings(bindings);
        return bindings;
    }

    private ScriptEngine obtainEngine() {
        return this.scriptEngineManager.getEngineByName("javascript");
    }

    private Object obtainQInstance(Context context, Bindings bindings) {
        if (this.qScript == null) {
            return null;
        }
        HttpServletRequest request = (HttpServletRequest)bindings.get("request");
        Object qInstance = null;
        if (request != null) {
            qInstance = request.getAttribute(REQ_NS);
        }
        if (qInstance == null) {
            qInstance = this.createQInstance(context, this.qScript);
            if (request != null) {
                request.setAttribute(REQ_NS, qInstance);
            }
        }
        return qInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptableObject createQScope() {
        Context context = Context.enter();
        try {
            ScriptableObject scope = context.initStandardObjects();
            ScriptableObject.putProperty((Scriptable)scope, (String)"setImmediate", (Object)((Object)TimingFunction.INSTANCE));
            ScriptableObject.putProperty((Scriptable)scope, (String)"setTimeout", (Object)((Object)TimingFunction.INSTANCE));
            ScriptableObject scriptableObject = scope;
            return scriptableObject;
        }
        finally {
            Context.exit();
        }
    }

    private Object createQInstance(Context context, Script qScript) {
        CommonJsModule module = new CommonJsModule();
        Scriptable tempScope = context.newObject((Scriptable)this.qScope);
        ScriptableObject.putProperty((Scriptable)tempScope, (String)"module", (Object)((Object)module));
        ScriptableObject.putProperty((Scriptable)tempScope, (String)"exports", (Object)module.getExports());
        qScript.exec(context, tempScope);
        return module.getExports();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Script loadQScript() {
        ResourceResolver resourceResolver = null;
        Context context = Context.enter();
        context.initStandardObjects();
        context.setOptimizationLevel(9);
        InputStream reader = null;
        try {
            resourceResolver = this.rrf.getAdministrativeResourceResolver(null);
            Resource resource = resourceResolver.getResource(Q_PATH);
            if (resource == null) {
                log.warn("Could not load Q library at path: /libs/sling/sightly/js/3rd-party/q.js");
                Script script = null;
                return script;
            }
            reader = (InputStream)resource.adaptTo(InputStream.class);
            if (reader == null) {
                log.warn("Could not read content of Q library");
                Script script = null;
                return script;
            }
            Script script = context.compileReader((Reader)new InputStreamReader(reader), Q_PATH, 0, null);
            return script;
        }
        catch (Exception e) {
            e.printStackTrace();
            Script script = null;
            return script;
        }
        finally {
            Context.exit();
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error("Error while closing reader", (Throwable)e);
                }
            }
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    protected void bindScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    protected void unbindScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        if (this.scriptEngineManager == scriptEngineManager) {
            this.scriptEngineManager = null;
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }
}

