/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.impl.compiler.CompilerBackend;
import org.apache.sling.scripting.sightly.impl.compiler.CompilerFrontend;
import org.apache.sling.scripting.sightly.impl.compiler.debug.SanityChecker;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.SimpleFrontend;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.CoalescingWrites;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.DeadCodeRemoval;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.SequenceStreamTransformer;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.StreamTransformer;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.SyntheticMapRemoval;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.UnusedVariableRemoval;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.reduce.ConstantFolding;
import org.apache.sling.scripting.sightly.impl.compiler.ris.CommandStream;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.PushStream;
import org.apache.sling.scripting.sightly.impl.filter.Filter;
import org.apache.sling.scripting.sightly.impl.html.dom.HtmlParserService;
import org.apache.sling.scripting.sightly.impl.plugin.Plugin;
import org.osgi.service.component.ComponentContext;

@Component
@Service(value={SightlyCompilerService.class})
@References(value={@Reference(policy=ReferencePolicy.DYNAMIC, referenceInterface=Filter.class, name="filterService", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE), @Reference(policy=ReferencePolicy.DYNAMIC, referenceInterface=Plugin.class, name="pluginService", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)})
public class SightlyCompilerService {
    private List<Filter> filters = new ArrayList<Filter>();
    private List<Plugin> plugins = new ArrayList<Plugin>();
    private static final Lock FILTERS_LOCK = new ReentrantLock();
    private static final Lock PLUGINS_LOCK = new ReentrantLock();
    private volatile StreamTransformer optimizer;
    private volatile CompilerFrontend frontend;
    private volatile boolean initialised = false;
    @Reference
    protected HtmlParserService htmlParserService;

    public void compile(String source, CompilerBackend backend) {
        this.initIfNeeded();
        PushStream stream = new PushStream();
        SanityChecker.attachChecker(stream);
        CommandStream optimizedStream = this.optimizer.transform(stream);
        backend.handle(optimizedStream);
        this.frontend.compile(stream, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNeeded() {
        if (!this.initialised) {
            SightlyCompilerService sightlyCompilerService = this;
            synchronized (sightlyCompilerService) {
                if (!this.initialised) {
                    ArrayList<StreamTransformer> transformers = new ArrayList<StreamTransformer>();
                    transformers.add(ConstantFolding.transformer());
                    transformers.add(DeadCodeRemoval.transformer());
                    transformers.add(SyntheticMapRemoval.TRANSFORMER);
                    transformers.add(UnusedVariableRemoval.TRANSFORMER);
                    transformers.add(CoalescingWrites.TRANSFORMER);
                    this.optimizer = new SequenceStreamTransformer(transformers);
                    this.initialised = true;
                }
            }
        }
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.initialised = false;
        this.reloadFrontend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindFilterService(Filter filter, Map<String, Object> properties) {
        FILTERS_LOCK.lock();
        try {
            this.filters = SightlyCompilerService.add(this.filters, filter);
            this.reloadFrontend();
        }
        finally {
            FILTERS_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindFilterService(Filter filter, Map<String, Object> properties) {
        FILTERS_LOCK.lock();
        try {
            this.filters = SightlyCompilerService.remove(this.filters, filter);
            this.reloadFrontend();
        }
        finally {
            FILTERS_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPluginService(Plugin plugin, Map<String, Object> properties) {
        PLUGINS_LOCK.lock();
        try {
            this.plugins = SightlyCompilerService.add(this.plugins, plugin);
            this.reloadFrontend();
        }
        finally {
            PLUGINS_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPluginService(Plugin plugin, Map<String, Object> properties) {
        PLUGINS_LOCK.lock();
        try {
            this.plugins = SightlyCompilerService.remove(this.plugins, plugin);
            this.reloadFrontend();
        }
        finally {
            PLUGINS_LOCK.unlock();
        }
    }

    private void reloadFrontend() {
        this.frontend = new SimpleFrontend(this.htmlParserService, this.plugins, this.filters);
    }

    private static <T> List<T> add(List<T> list, T item) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.add(item);
        return result;
    }

    private static <T> List<T> remove(List<T> list, T item) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.remove(item);
        return result;
    }

    protected void bindHtmlParserService(HtmlParserService htmlParserService) {
        this.htmlParserService = htmlParserService;
    }

    protected void unbindHtmlParserService(HtmlParserService htmlParserService) {
        if (this.htmlParserService == htmlParserService) {
            this.htmlParserService = null;
        }
    }
}

