/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.scripting.sightly.impl.compiler.Utils;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={UnitChangeMonitor.class})
public class UnitChangeMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(UnitChangeMonitor.class);
    private Map<String, SightlyScriptMetaInfo> slyScriptsMap = new ConcurrentHashMap<String, SightlyScriptMetaInfo>();
    private Map<String, Long> slyJavaUseMap = new ConcurrentHashMap<String, Long>();
    private ServiceRegistration eventHandlerServiceRegistration;
    @Reference
    private ResourceResolverFactory rrf = null;
    @Reference
    private SightlyEngineConfiguration sightlyEngineConfiguration = null;

    public long getLastModifiedDateForScript(String script) {
        SightlyScriptMetaInfo sightlyScriptMetaInfo = this.slyScriptsMap.get(script);
        if (sightlyScriptMetaInfo != null) {
            return sightlyScriptMetaInfo.lastModified;
        }
        return 0L;
    }

    public String getScriptEncoding(String script) {
        SightlyScriptMetaInfo sightlyScriptMetaInfo = this.getScript(script);
        if (sightlyScriptMetaInfo != null) {
            return sightlyScriptMetaInfo.encoding;
        }
        return this.sightlyEngineConfiguration.getEncoding();
    }

    public long getLastModifiedDateForJavaUseObject(String className) {
        if (className == null) {
            return 0L;
        }
        Long date = this.slyJavaUseMap.get(className);
        return date != null ? date : 0L;
    }

    public void clearJavaUseObject(String className) {
        if (StringUtils.isNotEmpty((String)className)) {
            this.slyJavaUseMap.remove(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext componentContext) {
        ResourceResolver adminResolver = null;
        try {
            String[] searchPaths;
            adminResolver = this.rrf.getAdministrativeResourceResolver(null);
            StringBuilder eventHandlerFilteredPaths = new StringBuilder("(|");
            for (String sp : searchPaths = adminResolver.getSearchPath()) {
                eventHandlerFilteredPaths.append("(path=").append(sp).append("**/*.").append("html").append(")");
                eventHandlerFilteredPaths.append("(path=").append(sp).append("**/*.java").append(")");
            }
            eventHandlerFilteredPaths.append(")");
            Hashtable<String, Object> eventHandlerProperties = new Hashtable<String, Object>();
            ((Dictionary)eventHandlerProperties).put("event.filter", eventHandlerFilteredPaths.toString());
            ((Dictionary)eventHandlerProperties).put("event.topics", new String[]{"org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/CHANGED", "org/apache/sling/api/resource/Resource/REMOVED"});
            this.eventHandlerServiceRegistration = componentContext.getBundleContext().registerService(EventHandler.class.getName(), (Object)new EventHandler(){

                public void handleEvent(Event event) {
                    UnitChangeMonitor.this.processEvent(event);
                }
            }, eventHandlerProperties);
        }
        catch (LoginException e) {
            LOG.error("Unable to listen for change events.", (Throwable)e);
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        if (this.eventHandlerServiceRegistration != null) {
            this.eventHandlerServiceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(Event event) {
        String path = (String)event.getProperty("path");
        String topic = event.getTopic();
        if ("org/apache/sling/api/resource/Resource/ADDED".equals(topic) || "org/apache/sling/api/resource/Resource/CHANGED".equals(topic)) {
            if (path.endsWith(".java")) {
                this.slyJavaUseMap.put(Utils.getJavaNameFromPath(path), System.currentTimeMillis());
            } else if (path.endsWith("html")) {
                ResourceResolver resolver = null;
                String encoding = null;
                try {
                    resolver = this.rrf.getAdministrativeResourceResolver(null);
                    ResourceMetadata scriptResourceMetadata = resolver.getResource(path).getResourceMetadata();
                    encoding = scriptResourceMetadata.getCharacterEncoding();
                }
                catch (LoginException e) {
                    LOG.warn("Cannot read character encoding value for script " + path);
                }
                finally {
                    if (resolver != null) {
                        resolver.close();
                    }
                }
                if (StringUtils.isEmpty((String)encoding)) {
                    encoding = this.sightlyEngineConfiguration.getEncoding();
                }
                this.slyScriptsMap.put(path, new SightlyScriptMetaInfo(encoding, System.currentTimeMillis()));
            }
        } else if ("org/apache/sling/api/resource/Resource/REMOVED".equals(topic)) {
            if (path.endsWith(".java")) {
                this.slyJavaUseMap.remove(Utils.getJavaNameFromPath(path));
            } else if (path.endsWith("html")) {
                this.slyScriptsMap.remove(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SightlyScriptMetaInfo getScript(String script) {
        SightlyScriptMetaInfo sightlyScriptMetaInfo = null;
        if (StringUtils.isNotEmpty((String)script) && (sightlyScriptMetaInfo = this.slyScriptsMap.get(script)) == null) {
            ResourceResolver resolver = null;
            try {
                resolver = this.rrf.getAdministrativeResourceResolver(null);
                Resource scriptResource = resolver.getResource(script);
                if (scriptResource == null) {
                    SightlyScriptMetaInfo sightlyScriptMetaInfo2 = null;
                    return sightlyScriptMetaInfo2;
                }
                ResourceMetadata scriptResourceMetadata = scriptResource.getResourceMetadata();
                String encoding = scriptResourceMetadata.getCharacterEncoding();
                if (StringUtils.isEmpty((String)encoding)) {
                    encoding = this.sightlyEngineConfiguration.getEncoding();
                }
                sightlyScriptMetaInfo = new SightlyScriptMetaInfo(encoding, scriptResourceMetadata.getModificationTime());
                this.slyScriptsMap.put(script, sightlyScriptMetaInfo);
            }
            catch (LoginException e) {
                LOG.warn("Cannot read character encoding value for script " + script);
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
            }
        }
        return sightlyScriptMetaInfo;
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    protected void bindSightlyEngineConfiguration(SightlyEngineConfiguration sightlyEngineConfiguration) {
        this.sightlyEngineConfiguration = sightlyEngineConfiguration;
    }

    protected void unbindSightlyEngineConfiguration(SightlyEngineConfiguration sightlyEngineConfiguration) {
        if (this.sightlyEngineConfiguration == sightlyEngineConfiguration) {
            this.sightlyEngineConfiguration = null;
        }
    }

    private static class SightlyScriptMetaInfo {
        String encoding;
        long lastModified;

        public SightlyScriptMetaInfo(String encoding, long lastModified) {
            this.encoding = encoding;
            this.lastModified = lastModified;
        }
    }
}

