/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;

@Component(metatype=true, label="Apache Sling Scripting Sightly Engine Configuration", description="Sightly Engine Configuration Options")
@Service(value={SightlyEngineConfiguration.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.devmode", boolValue={false}, label="Development Mode", description="If enabled, Sightly components will be recompiled at every request instead of loading objects from memory."), @Property(name="org.apache.sling.scripting.sightly.encoding", value={"UTF-8"}, label="Template Files Default Encoding", description="The default encoding used for reading Sightly template files (this directly affects how Sightly templatesare rendered)."), @Property(name="org.apache.sling.scripting.sightly.keepgenerated", boolValue={true}, label="Keep Generated Java Source Code", description="If enabled, the Java source code generated during Sightly template files compilation will be stored. Its location is dependent on the available org.apache.sling.commons.classloader.ClassLoaderWriter.")})
public class SightlyEngineConfiguration {
    public static final String SCR_PROP_NAME_DEVMODE = "org.apache.sling.scripting.sightly.devmode";
    public static final boolean SCR_PROP_DEFAULT_DEVMODE = false;
    public static final String SCR_PROP_NAME_ENCODING = "org.apache.sling.scripting.sightly.encoding";
    public static final String SCR_PROP_DEFAULT_ENCODING = "UTF-8";
    public static final String SCR_PROP_NAME_KEEPGENERATED = "org.apache.sling.scripting.sightly.keepgenerated";
    public static final boolean SCR_PROP_DEFAULT_KEEPGENERATED = true;
    private String engineVersion = "0";
    private boolean devMode = false;
    private String encoding = "UTF-8";
    private boolean keepGenerated;
    private String bundleSymbolicName = "_sightly";

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public String getScratchFolder() {
        return "/" + this.bundleSymbolicName.replaceAll("\\.", "/");
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean keepGenerated() {
        return this.keepGenerated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext componentContext) {
        InputStream ins = null;
        try {
            ins = this.getClass().getResourceAsStream("/META-INF/MANIFEST.MF");
            if (ins != null) {
                String symbolicName;
                Manifest manifest = new Manifest(ins);
                Attributes attrs = manifest.getMainAttributes();
                String version = attrs.getValue("ScriptEngine-Version");
                if (version != null) {
                    this.engineVersion = version;
                }
                if (StringUtils.isNotEmpty((String)(symbolicName = attrs.getValue("Bundle-SymbolicName")))) {
                    this.bundleSymbolicName = symbolicName;
                }
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ignore) {}
            }
        }
        Dictionary properties = componentContext.getProperties();
        this.devMode = PropertiesUtil.toBoolean(properties.get(SCR_PROP_NAME_DEVMODE), (boolean)false);
        this.encoding = PropertiesUtil.toString(properties.get(SCR_PROP_NAME_ENCODING), (String)SCR_PROP_DEFAULT_ENCODING);
        this.keepGenerated = PropertiesUtil.toBoolean(properties.get(SCR_PROP_NAME_KEEPGENERATED), (boolean)true);
    }
}

