/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.filter;

import java.util.Collection;
import java.util.Iterator;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;
import org.apache.sling.scripting.sightly.impl.filter.Filter;
import org.apache.sling.scripting.sightly.impl.filter.FilterComponent;
import org.apache.sling.scripting.sightly.impl.utils.RenderUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;

@Component
@Service(value={Filter.class, RuntimeExtension.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.extension.name", value={"join"})})
public class JoinFilter
extends FilterComponent
implements RuntimeExtension {
    public static final String JOIN_OPTION = "join";
    public static final String JOIN_FUNCTION = "join";

    @Override
    public Expression apply(Expression expression, ExpressionContext expressionContext) {
        if (!expression.containsOption("join") || expressionContext == ExpressionContext.PLUGIN_DATA_SLY_USE || expressionContext == ExpressionContext.PLUGIN_DATA_SLY_TEMPLATE || expressionContext == ExpressionContext.PLUGIN_DATA_SLY_CALL) {
            return expression;
        }
        RuntimeCall translation = new RuntimeCall("join", expression.getRoot(), expression.removeOption("join"));
        return expression.withNode(translation);
    }

    @Override
    public Object call(RenderContext renderContext, Object ... arguments) {
        if (arguments.length != 2) {
            throw new SightlyException("Join function must be called with two arguments.");
        }
        Object joinArgument = arguments[0];
        Collection<Object> collection = RenderUtils.toCollection(joinArgument);
        String joinString = RenderUtils.toString(arguments[1]);
        return this.join(collection, joinString);
    }

    private String join(Collection<?> collection, String joinString) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String element = RenderUtils.toString(iterator.next());
            sb.append(element);
            if (!iterator.hasNext()) continue;
            sb.append(joinString);
        }
        return sb.toString();
    }
}

