/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.scripting.sightly.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderUtils.class);
    public static final String TO_STRING_METHOD = "toString";
    public static final String PROPERTY_ACCESS = "resolveProperty";
    public static final String COLLECTION_COERCE = "toCollection";
    public static final String NUMERIC_COERCE = "toNumber";
    public static final String STRING_COERCE = "toString";
    public static final String BOOLEAN_COERCE = "toBoolean";
    private static final Set<Class<?>> primitiveClasses = RenderUtils.primitiveClasses();

    public static boolean isCollection(Object target) {
        return target instanceof Collection || target instanceof Object[] || target instanceof Iterable || target instanceof Iterator;
    }

    public static Number toNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        return 0;
    }

    public static String toString(Object target) {
        return RenderUtils.objectToString(target);
    }

    public static boolean toBoolean(Object object) {
        return RenderUtils.toBooleanInternal(object);
    }

    public static Collection<Object> toCollection(Object object) {
        return RenderUtils.obtainCollection(object);
    }

    public static Map toMap(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object instanceof Record) {
            HashMap map = new HashMap();
            Record record = (Record)object;
            Set<String> properties = record.getPropertyNames();
            for (String property : properties) {
                map.put(property, record.getProperty(property));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    public static Object resolveProperty(Object target, Object property) {
        Object resolved = property instanceof Number ? RenderUtils.getIndex(target, ((Number)property).intValue()) : RenderUtils.getProperty(target, property);
        return resolved;
    }

    private static Object getProperty(Object target, Object propertyObj) {
        String property = RenderUtils.toString(propertyObj);
        if (StringUtils.isEmpty((String)property)) {
            throw new IllegalArgumentException("Invalid property name");
        }
        if (target == null) {
            return null;
        }
        Object result = null;
        if (target instanceof Map) {
            result = RenderUtils.getMapProperty((Map)target, property);
        }
        if (result == null && target instanceof Record) {
            result = ((Record)target).getProperty(property);
        }
        if (result == null) {
            result = RenderUtils.getObjectProperty(target, property);
        }
        if (result == null && target instanceof Adaptable) {
            result = RenderUtils.getValueMapProperty((ValueMap)((Adaptable)target).adaptTo(ValueMap.class), property);
        }
        return result;
    }

    private static Collection<Object> obtainCollection(Object obj) {
        if (obj == null) {
            return Collections.emptyList();
        }
        if (obj instanceof Object[]) {
            return Arrays.asList((Object[])obj);
        }
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj instanceof Map) {
            return ((Map)obj).keySet();
        }
        if (obj instanceof Record) {
            return ((Record)obj).getPropertyNames();
        }
        if (obj instanceof Enumeration) {
            return Collections.list((Enumeration)obj);
        }
        if (obj instanceof Iterator) {
            return RenderUtils.fromIterator((Iterator)obj);
        }
        if (obj instanceof Iterable) {
            Iterable iterable = (Iterable)obj;
            return RenderUtils.fromIterator(iterable.iterator());
        }
        if (obj instanceof String || obj instanceof Number) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(obj);
            return list;
        }
        return Collections.emptyList();
    }

    private static Collection<Object> fromIterator(Iterator<Object> iterator) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    private static boolean toBooleanInternal(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return number.doubleValue() != 0.0;
        }
        String s = obj.toString().trim();
        if ("".equals(s)) {
            return false;
        }
        if ("true".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s)) {
            return Boolean.parseBoolean(s);
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size() > 0;
        }
        if (obj instanceof Map) {
            return ((Map)obj).size() > 0;
        }
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator().hasNext();
        }
        if (obj instanceof Iterator) {
            return ((Iterator)obj).hasNext();
        }
        return !(obj instanceof Object[]) || ((Object[])obj).length > 0;
    }

    private static Object getIndex(Object obj, int index) {
        Map map;
        if (obj instanceof Map && (map = (Map)obj).containsKey(index)) {
            return map.get(index);
        }
        Collection<Object> collection = RenderUtils.toCollection(obj);
        if (collection instanceof List) {
            return RenderUtils.getIndexSafe((List)collection, index);
        }
        return null;
    }

    private static Object getIndexSafe(List list, int index) {
        if (index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    private static Object getValueMapProperty(ValueMap valueMap, String property) {
        if (valueMap == null) {
            return null;
        }
        return valueMap.get((Object)property);
    }

    private static Object getMapProperty(Map map, String property) {
        return map.get(property);
    }

    private static Object getObjectProperty(Object obj, String property) {
        Object result = RenderUtils.getObjectNoArgMethod(obj, property);
        if (result == null) {
            result = RenderUtils.getField(obj, property);
        }
        return result;
    }

    private static Object getField(Object obj, String property) {
        if (obj instanceof Object[] && "length".equals(property)) {
            return ((Object[])obj).length;
        }
        Class<?> cls = obj.getClass();
        try {
            Field field = cls.getDeclaredField(property);
            return field.get(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getObjectNoArgMethod(Object obj, String property) {
        Class<?> cls = obj.getClass();
        Method method = RenderUtils.findMethod(cls, property);
        if (method != null) {
            method = RenderUtils.extractMethodInheritanceChain(cls, method);
            try {
                return method.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Cannot access method " + property + " on object " + obj.toString(), (Throwable)e);
            }
        }
        return null;
    }

    private static Method findMethod(Class<?> cls, String baseName) {
        Method[] publicMethods = cls.getMethods();
        String capitalized = StringUtils.capitalize((String)baseName);
        for (Method m : publicMethods) {
            String methodName;
            if (m.getParameterTypes().length != 0 || !baseName.equals(methodName = m.getName()) && !("get" + capitalized).equals(methodName) && !("is" + capitalized).equals(methodName)) continue;
            if (!RenderUtils.isMethodAllowed(m)) break;
            return m;
        }
        return null;
    }

    private static boolean isMethodAllowed(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        return declaringClass != Object.class || "toString".equals(method.getName());
    }

    private static String objectToString(Object obj) {
        String output = "";
        if (obj != null) {
            if (obj instanceof String) {
                output = (String)obj;
            } else if (RenderUtils.isPrimitive(obj)) {
                output = obj.toString();
            } else {
                Collection<Object> col = RenderUtils.obtainCollection(obj);
                if (col != null) {
                    output = RenderUtils.collectionToString(col);
                }
            }
        }
        return output;
    }

    public static boolean isPrimitive(Object obj) {
        return primitiveClasses.contains(obj.getClass());
    }

    private static String collectionToString(Collection<?> col) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        for (Object o : col) {
            builder.append(prefix).append(RenderUtils.objectToString(o));
            prefix = ",";
        }
        return builder.toString();
    }

    private static Set<Class<?>> primitiveClasses() {
        HashSet set = new HashSet();
        set.add(Boolean.class);
        set.add(Character.class);
        set.add(Byte.class);
        set.add(Short.class);
        set.add(Integer.class);
        set.add(Long.class);
        set.add(Float.class);
        set.add(Double.class);
        set.add(Void.class);
        return set;
    }

    private static Method extractMethodInheritanceChain(Class type, Method m) {
        Method mp;
        Class<?>[] inf;
        if (m == null || Modifier.isPublic(type.getModifiers())) {
            return m;
        }
        for (Class<?> iface : inf = type.getInterfaces()) {
            try {
                mp = iface.getMethod(m.getName(), m.getParameterTypes());
                mp = RenderUtils.extractMethodInheritanceChain(mp.getDeclaringClass(), mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        Class sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = RenderUtils.extractMethodInheritanceChain(mp.getDeclaringClass(), mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }
}

