/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={ResourceBackedPojoChangeMonitor.class, ResourceChangeListener.class})
@Properties(value={@Property(name="resource.paths", value={"glob:**/*.java"}), @Property(name="resource.change.types", value={"ADDED", "CHANGED", "REMOVED"})})
public class ResourceBackedPojoChangeMonitor
implements ResourceChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceBackedPojoChangeMonitor.class);
    private Map<String, Long> slyJavaUseMap = new ConcurrentHashMap<String, Long>();
    @Reference
    private SightlyEngineConfiguration sightlyEngineConfiguration = null;

    public long getLastModifiedDateForJavaUseObject(String className) {
        if (className == null) {
            return 0L;
        }
        Long date = this.slyJavaUseMap.get(className);
        return date != null ? date : 0L;
    }

    public void clearJavaUseObject(String className) {
        if (StringUtils.isNotEmpty((String)className)) {
            this.slyJavaUseMap.remove(className);
        }
    }

    public void onChange(@Nonnull List<ResourceChange> changes) {
        for (ResourceChange change : changes) {
            String path = change.getPath();
            ResourceChange.ChangeType changeType = change.getType();
            SourceIdentifier sourceIdentifier = new SourceIdentifier(this.sightlyEngineConfiguration, path);
            switch (changeType) {
                case ADDED: 
                case CHANGED: {
                    this.slyJavaUseMap.put(sourceIdentifier.getFullyQualifiedClassName(), System.currentTimeMillis());
                    break;
                }
                case REMOVED: {
                    this.slyJavaUseMap.remove(sourceIdentifier.getFullyQualifiedClassName());
                    break;
                }
            }
            LOG.debug("Java Use Object {} was {}.", (Object)path, (Object)changeType.toString());
        }
    }

    protected void bindSightlyEngineConfiguration(SightlyEngineConfiguration sightlyEngineConfiguration) {
        this.sightlyEngineConfiguration = sightlyEngineConfiguration;
    }

    protected void unbindSightlyEngineConfiguration(SightlyEngineConfiguration sightlyEngineConfiguration) {
        if (this.sightlyEngineConfiguration == sightlyEngineConfiguration) {
            this.sightlyEngineConfiguration = null;
        }
    }
}

