/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;

@Component(metatype=true, label="Apache Sling Scripting HTL Engine Configuration", description="HTL Engine Configuration Options")
@Service(value={SightlyEngineConfiguration.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.keepgenerated", boolValue={true}, label="Keep Generated Java Source Code", description="If enabled, the Java source code generated during HTL template files compilation will be stored. Its location is dependent on the available org.apache.sling.commons.classloader.ClassLoaderWriter.")})
public class SightlyEngineConfiguration {
    public static final String SCR_PROP_NAME_KEEPGENERATED = "org.apache.sling.scripting.sightly.keepgenerated";
    public static final boolean SCR_PROP_DEFAULT_KEEPGENERATED = true;
    private String engineVersion = "0";
    private boolean keepGenerated;
    private String bundleSymbolicName = "org.apache.sling.scripting.sightly";

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public String getScratchFolder() {
        return "/" + this.bundleSymbolicName.replaceAll("\\.", "/");
    }

    public boolean keepGenerated() {
        return this.keepGenerated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext componentContext) {
        InputStream ins = null;
        try {
            ins = this.getClass().getResourceAsStream("/META-INF/MANIFEST.MF");
            if (ins != null) {
                String symbolicName;
                Manifest manifest = new Manifest(ins);
                Attributes attrs = manifest.getMainAttributes();
                String version = attrs.getValue("ScriptEngine-Version");
                if (version != null) {
                    this.engineVersion = version;
                }
                if (StringUtils.isNotEmpty((String)(symbolicName = attrs.getValue("Bundle-SymbolicName")))) {
                    this.bundleSymbolicName = symbolicName;
                }
            }
        }
        catch (IOException manifest) {
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException manifest) {}
            }
        }
        Dictionary properties = componentContext.getProperties();
        this.keepGenerated = PropertiesUtil.toBoolean(properties.get(SCR_PROP_NAME_KEEPGENERATED), (boolean)true);
    }
}

