/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.script.Bindings;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={RuntimeExtension.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.extension.name", value={"i18n"})})
public class I18nRuntimeExtension
implements RuntimeExtension {
    private static final Logger LOG = LoggerFactory.getLogger(I18nRuntimeExtension.class);

    public Object call(RenderContext renderContext, Object ... arguments) {
        ExtensionUtils.checkArgumentCount("i18n", arguments, 2);
        RuntimeObjectModel runtimeObjectModel = renderContext.getObjectModel();
        String text = runtimeObjectModel.toString(arguments[0]);
        Map options = (Map)arguments[1];
        String locale = runtimeObjectModel.toString(options.get("locale"));
        String hint = runtimeObjectModel.toString(options.get("hint"));
        String basename = runtimeObjectModel.toString(options.get("basename"));
        Bindings bindings = renderContext.getBindings();
        return this.get(bindings, text, locale, basename, hint);
    }

    private String get(Bindings bindings, String text, String locale, String basename, String hint) {
        SlingScriptHelper slingScriptHelper = BindingsUtils.getHelper(bindings);
        SlingHttpServletRequest request = BindingsUtils.getRequest(bindings);
        ResourceBundleProvider resourceBundleProvider = (ResourceBundleProvider)slingScriptHelper.getService(ResourceBundleProvider.class);
        if (resourceBundleProvider != null) {
            String key = text;
            if (StringUtils.isNotEmpty((String)hint)) {
                key = key + " ((" + hint + "))";
            }
            if (StringUtils.isEmpty((String)locale)) {
                Enumeration requestLocales = request.getLocales();
                while (requestLocales.hasMoreElements()) {
                    Locale l = (Locale)requestLocales.nextElement();
                    String translation = this.getTranslation(resourceBundleProvider, basename, key, l);
                    if (translation == null) continue;
                    return translation;
                }
            } else {
                try {
                    Locale l = LocaleUtils.toLocale((String)locale);
                    String translation = this.getTranslation(resourceBundleProvider, basename, key, l);
                    if (translation != null) {
                        return translation;
                    }
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Invalid locale detected: {}.", (Object)locale);
                    return text;
                }
            }
        }
        LOG.warn("No translation found for string '{}' using expression provided locale '{}' or default locale '{}'", (Object[])new String[]{text, locale, request.getLocale().getLanguage()});
        return text;
    }

    private String getTranslation(ResourceBundleProvider resourceBundleProvider, String basename, String key, Locale locale) {
        ResourceBundle resourceBundle = StringUtils.isNotEmpty((String)basename) ? resourceBundleProvider.getResourceBundle(basename, locale) : resourceBundleProvider.getResourceBundle(locale);
        if (resourceBundle != null && resourceBundle.containsKey(key)) {
            return resourceBundle.getString(key);
        }
        return null;
    }
}

