/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.impl.engine.extension.PrintWriterResponseWrapper;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;

@Component
@Service(value={RuntimeExtension.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.extension.name", value={"includeResource"})})
public class ResourceRuntimeExtension
implements RuntimeExtension {
    private static final String OPTION_RESOURCE_TYPE = "resourceType";
    private static final String OPTION_PATH = "path";
    private static final String OPTION_PREPEND_PATH = "prependPath";
    private static final String OPTION_APPEND_PATH = "appendPath";
    private static final String OPTION_SELECTORS = "selectors";
    private static final String OPTION_REMOVE_SELECTORS = "removeSelectors";
    private static final String OPTION_ADD_SELECTORS = "addSelectors";
    private static final String OPTION_REPLACE_SELECTORS = "replaceSelectors";
    private static final String OPTION_REQUEST_ATTRIBUTES = "requestAttributes";

    public Object call(RenderContext renderContext, Object ... arguments) {
        ExtensionUtils.checkArgumentCount("includeResource", arguments, 2);
        return this.provideResource(renderContext, arguments[0], (Map)arguments[1]);
    }

    private String provideResource(RenderContext renderContext, Object pathObj, Map<String, Object> options) {
        HashMap<String, Object> opts = new HashMap<String, Object>(options);
        Bindings bindings = renderContext.getBindings();
        SlingHttpServletRequest request = BindingsUtils.getRequest(bindings);
        Map<String, Object> originalAttributes = ExtensionUtils.setRequestAttributes(request, (Map)options.remove(OPTION_REQUEST_ATTRIBUTES));
        String resourceType = this.coerceString(this.getAndRemoveOption(opts, OPTION_RESOURCE_TYPE));
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        if (pathObj instanceof Resource) {
            Resource includeRes = (Resource)pathObj;
            Map<String, String> dispatcherOptionsMap = this.handleSelectors(bindings, new LinkedHashSet<String>(), opts);
            String dispatcherOptions = this.createDispatcherOptions(dispatcherOptionsMap);
            this.includeResource(bindings, printWriter, includeRes, dispatcherOptions, resourceType);
        } else {
            PathInfo pathInfo = new PathInfo(this.coerceString(pathObj));
            String finalPath = this.buildPath(pathInfo.path, opts, BindingsUtils.getResource(bindings));
            Map<String, String> dispatcherOptionsMap = this.handleSelectors(bindings, pathInfo.selectors, opts);
            String dispatcherOptions = this.createDispatcherOptions(dispatcherOptionsMap);
            this.includeResource(bindings, printWriter, finalPath, dispatcherOptions, resourceType);
        }
        ExtensionUtils.setRequestAttributes(request, originalAttributes);
        return writer.toString();
    }

    private Map<String, String> handleSelectors(Bindings bindings, Set<String> selectors, Map<String, Object> options) {
        Object selectorsObject;
        if (selectors.isEmpty()) {
            SlingHttpServletRequest request = BindingsUtils.getRequest(bindings);
            selectors.addAll(Arrays.asList(request.getRequestPathInfo().getSelectors()));
        }
        HashMap<String, String> dispatcherOptionsMap = new HashMap<String, String>();
        dispatcherOptionsMap.put(OPTION_ADD_SELECTORS, this.getSelectorString(selectors));
        dispatcherOptionsMap.put(OPTION_REPLACE_SELECTORS, " ");
        if (options.containsKey(OPTION_SELECTORS)) {
            selectorsObject = this.getAndRemoveOption(options, OPTION_SELECTORS);
            selectors.clear();
            this.addSelectors(selectors, selectorsObject);
            dispatcherOptionsMap.put(OPTION_ADD_SELECTORS, this.getSelectorString(selectors));
            dispatcherOptionsMap.put(OPTION_REPLACE_SELECTORS, " ");
        }
        if (options.containsKey(OPTION_ADD_SELECTORS)) {
            selectorsObject = this.getAndRemoveOption(options, OPTION_ADD_SELECTORS);
            this.addSelectors(selectors, selectorsObject);
            dispatcherOptionsMap.put(OPTION_ADD_SELECTORS, this.getSelectorString(selectors));
            dispatcherOptionsMap.put(OPTION_REPLACE_SELECTORS, " ");
        }
        if (options.containsKey(OPTION_REMOVE_SELECTORS)) {
            String selectorString;
            selectorsObject = this.getAndRemoveOption(options, OPTION_REMOVE_SELECTORS);
            if (selectorsObject instanceof String) {
                String[] parts;
                selectorString = (String)selectorsObject;
                for (String s : parts = selectorString.split("\\.")) {
                    selectors.remove(s);
                }
            } else if (selectorsObject instanceof Object[]) {
                for (Object s : (Object[])selectorsObject) {
                    String selector = this.coerceString(s);
                    if (!StringUtils.isNotEmpty((String)selector)) continue;
                    selectors.remove(selector);
                }
            } else if (selectorsObject == null) {
                selectors.clear();
            }
            if (StringUtils.isEmpty((String)(selectorString = this.getSelectorString(selectors)))) {
                dispatcherOptionsMap.put(OPTION_REPLACE_SELECTORS, " ");
            } else {
                dispatcherOptionsMap.put(OPTION_ADD_SELECTORS, this.getSelectorString(selectors));
                dispatcherOptionsMap.put(OPTION_REPLACE_SELECTORS, " ");
            }
        }
        return dispatcherOptionsMap;
    }

    private void addSelectors(Set<String> selectors, Object selectorsObject) {
        if (selectorsObject instanceof String) {
            String selectorString = (String)selectorsObject;
            String[] parts = selectorString.split("\\.");
            selectors.addAll(Arrays.asList(parts));
        } else if (selectorsObject instanceof Object[]) {
            for (Object s : (Object[])selectorsObject) {
                String selector = this.coerceString(s);
                if (!StringUtils.isNotEmpty((String)selector)) continue;
                selectors.add(selector);
            }
        }
    }

    private String buildPath(Object pathObj, Map<String, Object> options, Resource currentResource) {
        String finalPath;
        String path;
        String prependPath = this.getOption(OPTION_PREPEND_PATH, options, "");
        if (prependPath == null) {
            prependPath = "";
        }
        if (StringUtils.isNotEmpty((String)prependPath)) {
            if (!prependPath.startsWith("/")) {
                prependPath = "/" + prependPath;
            }
            if (!prependPath.endsWith("/")) {
                prependPath = prependPath + "/";
            }
        }
        path = this.getOption(OPTION_PATH, options, StringUtils.isNotEmpty((String)(path = this.coerceString(pathObj))) ? path : "");
        String appendPath = this.getOption(OPTION_APPEND_PATH, options, "");
        if (appendPath == null) {
            appendPath = "";
        }
        if (StringUtils.isNotEmpty((String)appendPath) && !appendPath.startsWith("/")) {
            appendPath = "/" + appendPath;
        }
        if (!(finalPath = prependPath + path + appendPath).startsWith("/")) {
            finalPath = currentResource.getPath() + "/" + finalPath;
        }
        return ResourceUtil.normalize((String)finalPath);
    }

    private String createDispatcherOptions(Map<String, String> options) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean hasPreceding = false;
        for (Map.Entry<String, String> option : options.entrySet()) {
            if (hasPreceding) {
                buffer.append(", ");
            }
            String key = option.getKey();
            buffer.append(key).append("=");
            String strVal = option.getValue();
            if (strVal == null) {
                strVal = "";
            }
            buffer.append(strVal);
            hasPreceding = true;
        }
        return buffer.toString();
    }

    private String coerceString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    private String getOption(String option, Map<String, Object> options, String defaultValue) {
        if (options.containsKey(option)) {
            return (String)options.get(option);
        }
        return defaultValue;
    }

    private Object getAndRemoveOption(Map<String, Object> options, String property) {
        return options.remove(property);
    }

    private void includeResource(Bindings bindings, PrintWriter out, String script, String dispatcherOptions, String resourceType) {
        if (StringUtils.isEmpty((String)script)) {
            throw new SightlyException("Resource path cannot be empty");
        }
        SlingHttpServletRequest request = BindingsUtils.getRequest(bindings);
        script = this.normalizePath(request, script);
        Resource includeRes = request.getResourceResolver().resolve(script);
        if (ResourceUtil.isNonExistingResource((Resource)includeRes)) {
            includeRes = new SyntheticResource(request.getResourceResolver(), script, resourceType);
        }
        this.includeResource(bindings, out, includeRes, dispatcherOptions, resourceType);
    }

    private void includeResource(Bindings bindings, PrintWriter out, Resource includeRes, String dispatcherOptions, String resourceType) {
        if (includeRes == null) {
            throw new SightlyException("Resource cannot be null");
        }
        PrintWriterResponseWrapper customResponse = new PrintWriterResponseWrapper(out, BindingsUtils.getResponse(bindings));
        SlingHttpServletRequest request = BindingsUtils.getRequest(bindings);
        RequestDispatcherOptions opts = new RequestDispatcherOptions(dispatcherOptions);
        if (StringUtils.isNotEmpty((String)resourceType)) {
            opts.setForceResourceType(resourceType);
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher(includeRes, opts);
        try {
            if (dispatcher == null) {
                throw new SightlyException("Failed to include resource " + includeRes.getPath());
            }
            dispatcher.include((ServletRequest)request, (ServletResponse)customResponse);
        }
        catch (Exception e) {
            throw new SightlyException("Failed to include resource " + includeRes.getPath(), e);
        }
    }

    private String normalizePath(SlingHttpServletRequest request, String path) {
        if (!path.startsWith("/")) {
            path = request.getResource().getPath() + "/" + path;
        }
        return ResourceUtil.normalize((String)path);
    }

    private Set<String> getSelectorsFromPath(String path) {
        LinkedHashSet<String> selectors = new LinkedHashSet<String>();
        if (path != null) {
            int lastDotPos;
            int dotPos;
            String processingPath = path;
            int lastSlashPos = path.lastIndexOf(47);
            if (lastSlashPos > -1) {
                processingPath = path.substring(lastSlashPos + 1, path.length());
            }
            if ((dotPos = processingPath.indexOf(46)) > -1 && (lastDotPos = processingPath.lastIndexOf(46)) > dotPos) {
                String selectorString = processingPath.substring(dotPos + 1, lastDotPos);
                String[] selectorParts = selectorString.split("\\.");
                selectors.addAll(Arrays.asList(selectorParts));
            }
        }
        return selectors;
    }

    private String getSelectorString(Set<String> selectors) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String s : selectors) {
            sb.append(s);
            if (i >= selectors.size() - 1) continue;
            sb.append(".");
            ++i;
        }
        return sb.toString();
    }

    private class PathInfo {
        private String path;
        private Set<String> selectors;

        PathInfo(String path) {
            this.selectors = ResourceRuntimeExtension.this.getSelectorsFromPath(path);
            if (this.selectors.isEmpty()) {
                this.path = path;
            } else {
                String selectorString = ResourceRuntimeExtension.this.getSelectorString(this.selectors);
                this.path = path.replace("." + selectorString, "");
            }
        }
    }
}

