/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension.use;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@Component
@Service(value={RuntimeExtension.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.extension.name", value={"use"})})
@Reference(policy=ReferencePolicy.DYNAMIC, referenceInterface=UseProvider.class, name="useProvider", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)
public class UseRuntimeExtension
implements RuntimeExtension {
    private final Map<ServiceReference, UseProvider> providersMap = new ConcurrentSkipListMap<ServiceReference, UseProvider>();

    public Object call(RenderContext renderContext, Object ... arguments) {
        ExtensionUtils.checkArgumentCount("use", arguments, 2);
        RuntimeObjectModel runtimeObjectModel = renderContext.getObjectModel();
        String identifier = runtimeObjectModel.toString(arguments[0]);
        if (StringUtils.isEmpty((String)identifier)) {
            throw new SightlyException("data-sly-use needs to be passed an identifier");
        }
        Map useArgumentsMap = runtimeObjectModel.toMap(arguments[1]);
        SimpleBindings useArguments = new SimpleBindings(Collections.unmodifiableMap(useArgumentsMap));
        ArrayList<UseProvider> providers = new ArrayList<UseProvider>(this.providersMap.values());
        ListIterator<UseProvider> iterator = providers.listIterator(providers.size());
        while (iterator.hasPrevious()) {
            UseProvider provider = iterator.previous();
            ProviderOutcome outcome = provider.provide(identifier, renderContext, (Bindings)useArguments);
            if (outcome.isSuccess()) {
                return outcome.getResult();
            }
            Throwable failureCause = outcome.getCause();
            if (failureCause == null) continue;
            throw new SightlyException("Identifier " + identifier + " cannot be correctly instantiated by the Use API", failureCause);
        }
        throw new SightlyException("No use provider could resolve identifier " + identifier);
    }

    private void bindUseProvider(ServiceReference serviceReference) {
        BundleContext bundleContext = serviceReference.getBundle().getBundleContext();
        this.providersMap.put(serviceReference, (UseProvider)bundleContext.getService(serviceReference));
    }

    private void unbindUseProvider(ServiceReference serviceReference) {
        this.providersMap.remove(serviceReference);
    }
}

