/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.scripting.sightly.SightlyException;

public class ExtensionUtils {
    public static void checkArgumentCount(String extensionName, Object[] arguments, int count) {
        if (arguments.length != count) {
            throw new SightlyException(String.format("Extension %s requires %d arguments", extensionName, count));
        }
    }

    public static Map<String, Object> setRequestAttributes(SlingHttpServletRequest request, Map<String, Object> newRequestAttributes) {
        LinkedHashMap<String, Object> originalRequestAttributes = new LinkedHashMap<String, Object>();
        if (newRequestAttributes != null && request != null) {
            for (Map.Entry<String, Object> attr : newRequestAttributes.entrySet()) {
                String key = attr.getKey();
                Object value = attr.getValue();
                originalRequestAttributes.put(key, request.getAttribute(key));
                if (value == null) {
                    request.removeAttribute(key);
                    continue;
                }
                request.setAttribute(key, value);
            }
        }
        return originalRequestAttributes;
    }
}

