/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sling.scripting.sightly.impl.compiler.ris.CommandVisitor;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Conditional;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Loop;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.OutText;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.OutVariable;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Procedure;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.VariableBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalShadowChecker
implements CommandVisitor {
    private static final Logger log = LoggerFactory.getLogger(GlobalShadowChecker.class);
    private final Map<String, String> globals = new HashMap<String, String>();

    public GlobalShadowChecker(Set<String> globals) {
        for (String global : globals) {
            this.globals.put(global.toLowerCase(), global);
        }
    }

    @Override
    public void visit(Conditional.Start conditionalStart) {
    }

    @Override
    public void visit(Conditional.End conditionalEnd) {
    }

    @Override
    public void visit(VariableBinding.Start variableBindingStart) {
        this.checkVariable(variableBindingStart.getVariableName());
    }

    @Override
    public void visit(VariableBinding.End variableBindingEnd) {
    }

    @Override
    public void visit(VariableBinding.Global globalAssignment) {
        this.checkVariable(globalAssignment.getVariableName());
    }

    @Override
    public void visit(OutVariable outVariable) {
    }

    @Override
    public void visit(OutText outText) {
    }

    @Override
    public void visit(Loop.Start loopStart) {
        this.checkVariable(loopStart.getItemVariable());
        this.checkVariable(loopStart.getIndexVariable());
    }

    @Override
    public void visit(Loop.End loopEnd) {
    }

    @Override
    public void visit(Procedure.Start startProcedure) {
        this.checkVariable(startProcedure.getName());
    }

    @Override
    public void visit(Procedure.End endProcedure) {
    }

    @Override
    public void visit(Procedure.Call procedureCall) {
    }

    private void checkVariable(String variableName) {
        if (this.globals.containsKey(variableName = variableName.toLowerCase())) {
            String originalName = this.globals.get(variableName);
            log.warn("Global variable '{}' is being overridden in template", (Object)originalName);
        }
    }
}

