/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.script.Bindings;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.impl.utils.RenderUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={RuntimeExtension.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.extension.name", value={"i18nTranslation"})})
public class I18nRuntimeExtension
implements RuntimeExtension {
    private static final Logger LOG = LoggerFactory.getLogger(I18nRuntimeExtension.class);

    @Override
    public Object call(RenderContext renderContext, Object ... arguments) {
        ExtensionUtils.checkArgumentCount("i18nTranslation", arguments, 2);
        String text = RenderUtils.toString(arguments[0]);
        Map options = (Map)arguments[1];
        String locale = RenderUtils.toString(options.get("locale"));
        String hint = RenderUtils.toString(options.get("hint"));
        Bindings bindings = renderContext.getBindings();
        return this.get(bindings, text, locale, hint);
    }

    private String get(Bindings bindings, String text, String locale, String hint) {
        SlingScriptHelper slingScriptHelper = (SlingScriptHelper)bindings.get("sling");
        SlingHttpServletRequest request = (SlingHttpServletRequest)bindings.get("request");
        ResourceBundleProvider resourceBundleProvider = (ResourceBundleProvider)slingScriptHelper.getService(ResourceBundleProvider.class);
        if (resourceBundleProvider != null) {
            String key = text;
            if (StringUtils.isNotEmpty((String)hint)) {
                key = key + " ((" + hint + "))";
            }
            if (StringUtils.isEmpty((String)locale)) {
                Enumeration requestLocales = request.getLocales();
                while (requestLocales.hasMoreElements()) {
                    Locale l = (Locale)requestLocales.nextElement();
                    ResourceBundle resourceBundle = resourceBundleProvider.getResourceBundle(l);
                    if (resourceBundle == null || !resourceBundle.containsKey(key)) continue;
                    return resourceBundle.getString(key);
                }
            } else {
                Locale l = new Locale(locale);
                ResourceBundle resourceBundle = resourceBundleProvider.getResourceBundle(l);
                if (resourceBundle != null && resourceBundle.containsKey(key)) {
                    return resourceBundle.getString(key);
                }
            }
        }
        LOG.warn("No translation found for string '{}' using expression provided locale '{}' or default locale '{}'", (Object[])new String[]{text, locale, request.getLocale().getLanguage()});
        return text;
    }
}

