/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.filter;

import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.impl.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;
import org.apache.sling.scripting.sightly.impl.filter.Filter;
import org.apache.sling.scripting.sightly.impl.filter.FilterComponent;

@Component
@Service(value={Filter.class})
@Property(name="org.apache.sling.scripting.sightly.impl.filter.priority", intValue={110})
public class XSSFilter
extends FilterComponent {
    public static final String FUNCTION_NAME = "xss";

    @Override
    public Expression apply(Expression expression, ExpressionContext expressionContext) {
        if (expressionContext == ExpressionContext.PLUGIN_DATA_SLY_USE || expressionContext == ExpressionContext.PLUGIN_DATA_SLY_TEMPLATE || expressionContext == ExpressionContext.PLUGIN_DATA_SLY_CALL) {
            return expression;
        }
        ExpressionNode node = expression.getRoot();
        Map<String, ExpressionNode> options = expression.getOptions();
        ExpressionNode context = options.get("context");
        if (context != null) {
            return new Expression(new RuntimeCall(FUNCTION_NAME, node, context), options);
        }
        return expression;
    }
}

