/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.impl.compiler.common.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BooleanConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.StringConstant;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.compiler.ris.Command;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Conditional;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Patterns;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.VariableBinding;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.PushStream;
import org.apache.sling.scripting.sightly.impl.plugin.Plugin;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginComponent;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

@Component
@Service(value={Plugin.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.impl.plugin.name", value={"unwrap"}), @Property(name="org.apache.sling.scripting.sightly.impl.plugin.priority", intValue={125})})
public class UnwrapPlugin
extends PluginComponent {
    @Override
    public PluginInvoke invoke(final Expression expression, PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){
            private final String variable;
            private final Command unwrapTest;
            private boolean isSlyTag;
            {
                this.variable = compilerContext.generateVariable("unwrapCondition");
                this.unwrapTest = new Conditional.Start(this.variable, false);
                this.isSlyTag = false;
            }

            @Override
            public void beforeElement(PushStream stream, String tagName) {
                this.isSlyTag = "sly".equals(tagName.toLowerCase());
                stream.emit(new VariableBinding.Start(this.variable, this.testNode()));
            }

            @Override
            public void beforeTagOpen(PushStream stream) {
                if (this.isSlyTag) {
                    Patterns.endStreamIgnore(stream);
                }
                stream.emit(this.unwrapTest);
            }

            @Override
            public void afterTagOpen(PushStream stream) {
                stream.emit(Conditional.END);
                if (this.isSlyTag) {
                    Patterns.beginStreamIgnore(stream);
                }
            }

            @Override
            public void beforeTagClose(PushStream stream, boolean isSelfClosing) {
                if (this.isSlyTag) {
                    Patterns.endStreamIgnore(stream);
                }
                stream.emit(this.unwrapTest);
            }

            @Override
            public void afterTagClose(PushStream stream, boolean isSelfClosing) {
                stream.emit(Conditional.END);
                if (this.isSlyTag) {
                    Patterns.beginStreamIgnore(stream);
                }
            }

            @Override
            public void afterElement(PushStream stream) {
                stream.emit(VariableBinding.END);
            }

            private ExpressionNode testNode() {
                return this.isEmptyExpression(expression.getRoot()) ? BooleanConstant.TRUE : expression.getRoot();
            }

            private boolean isEmptyExpression(ExpressionNode node) {
                return node instanceof StringConstant && ((StringConstant)node).getText().isEmpty();
            }
        };
    }
}

