/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiled.operator;

import org.apache.sling.scripting.sightly.impl.compiled.ExpressionTranslator;
import org.apache.sling.scripting.sightly.impl.compiled.GenHelper;
import org.apache.sling.scripting.sightly.impl.compiled.JavaSource;
import org.apache.sling.scripting.sightly.impl.compiled.Type;
import org.apache.sling.scripting.sightly.impl.compiled.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.TypedNode;

public class NumericOpGen
implements BinaryOpGen {
    private final String javaOperator;

    public NumericOpGen(String javaOperator) {
        this.javaOperator = javaOperator;
    }

    @Override
    public Type returnType(Type leftType, Type rightType) {
        return this.commonType(leftType, rightType);
    }

    @Override
    public void generate(JavaSource source, ExpressionTranslator visitor, TypedNode left, TypedNode right) {
        Type commonType = this.commonType(left.getType(), right.getType());
        GenHelper.typeCoercion(source, visitor, left, commonType);
        source.append(this.javaOperator);
        GenHelper.typeCoercion(source, visitor, right, commonType);
    }

    protected Type commonType(Type leftType, Type rightType) {
        if (leftType == rightType && leftType == Type.LONG) {
            return Type.LONG;
        }
        return Type.DOUBLE;
    }
}

