/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import java.util.HashMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.impl.compiler.Syntax;
import org.apache.sling.scripting.sightly.impl.compiler.common.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BinaryOperation;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BinaryOperator;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.Identifier;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.MapLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.NumericConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.UnaryOperation;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.UnaryOperator;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Conditional;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Loop;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.VariableBinding;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.PushStream;
import org.apache.sling.scripting.sightly.impl.plugin.Plugin;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginComponent;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

@Component
@Service(value={Plugin.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.impl.plugin.name", value={"repeat"}), @Property(name="org.apache.sling.scripting.sightly.impl.plugin.priority", intValue={130})})
public class RepeatPlugin
extends PluginComponent {
    private static final String INDEX = "index";
    private static final String COUNT = "count";
    private static final String FIRST = "first";
    private static final String MIDDLE = "middle";
    private static final String LAST = "last";
    private static final String ODD = "odd";
    private static final String EVEN = "even";

    @Override
    public PluginInvoke invoke(final Expression expression, final PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){
            private String listVariable;
            private String collectionSizeVar;
            {
                this.listVariable = compilerContext.generateVariable("collectionVar");
                this.collectionSizeVar = compilerContext.generateVariable("size");
            }

            @Override
            public void beforeElement(PushStream stream, String tagName) {
                stream.emit(new VariableBinding.Start(this.listVariable, expression.getRoot()));
                stream.emit(new VariableBinding.Start(this.collectionSizeVar, new UnaryOperation(UnaryOperator.LENGTH, new Identifier(this.listVariable))));
                stream.emit(new Conditional.Start(this.collectionSizeVar, true));
                String itemVariable = this.decodeItemVariable();
                String loopStatusVar = Syntax.itemLoopStatusVariable(itemVariable);
                String indexVariable = compilerContext.generateVariable(RepeatPlugin.INDEX);
                stream.emit(new Loop.Start(this.listVariable, itemVariable, indexVariable));
                stream.emit(new VariableBinding.Start(loopStatusVar, this.buildStatusObj(indexVariable, this.collectionSizeVar)));
            }

            @Override
            public void afterElement(PushStream stream) {
                stream.emit(VariableBinding.END);
                stream.emit(Loop.END);
                stream.emit(Conditional.END);
                stream.emit(VariableBinding.END);
                stream.emit(VariableBinding.END);
            }

            private String decodeItemVariable() {
                String[] args = callInfo.getArguments();
                if (args.length > 0) {
                    return args[0];
                }
                return "item";
            }

            private MapLiteral buildStatusObj(String indexVar, String sizeVar) {
                HashMap<String, ExpressionNode> obj = new HashMap<String, ExpressionNode>();
                Identifier indexId = new Identifier(indexVar);
                BinaryOperation firstExpr = new BinaryOperation(BinaryOperator.EQ, indexId, NumericConstant.ZERO);
                BinaryOperation lastExpr = new BinaryOperation(BinaryOperator.EQ, indexId, new BinaryOperation(BinaryOperator.SUB, new Identifier(sizeVar), NumericConstant.ONE));
                obj.put(RepeatPlugin.INDEX, indexId);
                obj.put(RepeatPlugin.COUNT, new BinaryOperation(BinaryOperator.ADD, indexId, NumericConstant.ONE));
                obj.put(RepeatPlugin.FIRST, firstExpr);
                obj.put(RepeatPlugin.MIDDLE, new UnaryOperation(UnaryOperator.NOT, new BinaryOperation(BinaryOperator.OR, firstExpr, lastExpr)));
                obj.put(RepeatPlugin.LAST, lastExpr);
                obj.put(RepeatPlugin.ODD, this.parityCheck(indexId, NumericConstant.ZERO));
                obj.put(RepeatPlugin.EVEN, this.parityCheck(indexId, NumericConstant.ONE));
                return new MapLiteral(obj);
            }

            private ExpressionNode parityCheck(ExpressionNode numericExpression, NumericConstant expected) {
                return new BinaryOperation(BinaryOperator.EQ, new BinaryOperation(BinaryOperator.REM, numericExpression, NumericConstant.TWO), expected);
            }
        };
    }
}

