/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.servlets.post.AbstractPostResponse;

public class JSONResponse
extends AbstractPostResponse {
    public static final String RESPONSE_CONTENT_TYPE = "application/json";
    static final String PROP_TYPE = "type";
    static final String PROP_ARGUMENT = "argument";
    static final String RESPONSE_CHARSET = "UTF-8";
    private static final String PROP_CHANGES = "changes";
    private JSONObject json = new JSONObject();
    private JSONArray changes = new JSONArray();
    private Throwable error;

    public JSONResponse() throws JSONResponseException {
        try {
            this.json = new JSONObject();
            this.changes = new JSONArray();
            this.json.put(PROP_CHANGES, (Object)this.changes);
        }
        catch (Throwable e) {
            throw new JSONResponseException(e);
        }
    }

    @Override
    public void onChange(String type, String ... arguments) throws JSONResponseException {
        try {
            JSONObject change = new JSONObject();
            change.put(PROP_TYPE, (Object)type);
            for (String argument : arguments) {
                change.accumulate(PROP_ARGUMENT, (Object)argument);
            }
            this.changes.put((Object)change);
        }
        catch (JSONException e) {
            throw new JSONResponseException((Throwable)e);
        }
    }

    @Override
    public void setError(Throwable error) {
        try {
            this.error = error;
            JSONObject jsonError = new JSONObject();
            jsonError.put("class", (Object)error.getClass().getName());
            jsonError.put("message", (Object)error.getMessage());
            this.json.put("error", (Object)jsonError);
        }
        catch (JSONException e) {
            throw new JSONResponseException((Throwable)e);
        }
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public void setProperty(String name, Object value) {
        try {
            this.json.put(name, value);
        }
        catch (Throwable e) {
            throw new JSONResponseException("Error setting JSON property '" + name + "' to '" + value + "'", e);
        }
    }

    @Override
    public Object getProperty(String name) throws JSONResponseException {
        try {
            if (this.json.has(name)) {
                return this.json.get(name);
            }
            return null;
        }
        catch (JSONException e) {
            throw new JSONResponseException("Error getting JSON property '" + name + "'", e);
        }
    }

    @Override
    protected void doSend(HttpServletResponse response) throws IOException {
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setCharacterEncoding(RESPONSE_CHARSET);
        try {
            this.json.write((Writer)response.getWriter());
        }
        catch (JSONException e) {
            IOException ioe = new IOException("Error creating JSON response");
            ioe.initCause(e);
            throw ioe;
        }
    }

    JSONObject getJson() {
        return this.json;
    }

    public class JSONResponseException
    extends RuntimeException {
        public JSONResponseException(String message, Throwable exception) {
            super(message, exception);
        }

        public JSONResponseException(Throwable e) {
            super("Error building JSON response", e);
        }
    }
}

