/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingFileUploadHandler {
    public static final String NT_FOLDER = "nt:folder";
    public static final String NT_FILE = "nt:file";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_LASTMODIFIED = "jcr:lastModified";
    public static final String JCR_MIMETYPE = "jcr:mimeType";
    public static final String JCR_ENCODING = "jcr:encoding";
    public static final String JCR_DATA = "jcr:data";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ServletContext servletContext;
    private static final String MT_APP_OCTET = "application/octet-stream";

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private void setFile(Resource parentResource, Node parent, RequestProperty prop, RequestParameter value, List<Modification> changes, String name, String contentType) throws RepositoryException, PersistenceException {
        Resource resParent;
        boolean createNtFile = parent.isNodeType(NT_FOLDER);
        String typeHint = prop.getTypeHint();
        if (typeHint != null) {
            try {
                NodeTypeManager ntMgr = parent.getSession().getWorkspace().getNodeTypeManager();
                NodeType nt = ntMgr.getNodeType(typeHint);
                createNtFile = nt.isNodeType(NT_FILE);
            }
            catch (RepositoryException e) {
                typeHint = null;
            }
        }
        if (!createNtFile && name.indexOf(46) > 0) {
            createNtFile = true;
        }
        if (typeHint == null) {
            String string = typeHint = createNtFile ? NT_FILE : NT_RESOURCE;
        }
        if (createNtFile) {
            resParent = this.getOrCreateChildResource(parentResource, name, typeHint, changes);
            name = JCR_CONTENT;
            typeHint = NT_RESOURCE;
        } else {
            resParent = parentResource;
        }
        Resource newResource = this.getOrCreateChildResource(resParent, name, typeHint, changes);
        Node res = (Node)newResource.adaptTo(Node.class);
        changes.add(Modification.onModified(res.setProperty(JCR_LASTMODIFIED, Calendar.getInstance()).getPath()));
        changes.add(Modification.onModified(res.setProperty(JCR_MIMETYPE, contentType).getPath()));
        try {
            if (prop.isChunkUpload()) {
                this.processChunk(resParent, res, prop, value, changes);
            } else {
                changes.add(Modification.onModified(res.setProperty(JCR_DATA, value.getInputStream()).getPath()));
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Error while retrieving inputstream from parameter value.", (Throwable)e);
        }
    }

    private void setFile(Resource parentResource, RequestProperty prop, RequestParameter value, List<Modification> changes, String name, String contentType) throws PersistenceException, RepositoryException {
        String typeHint = prop.getTypeHint();
        if (typeHint == null) {
            typeHint = NT_FILE;
        }
        if (prop.isChunkUpload()) {
            throw new RepositoryException("Cannot process chunk upload request. Parent resource [" + parentResource.getPath() + "] doesn't exists");
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("sling:resourceType", typeHint);
        props.put(JCR_LASTMODIFIED, Calendar.getInstance());
        props.put(JCR_MIMETYPE, contentType);
        try {
            props.put(JCR_DATA, value.getInputStream());
        }
        catch (IOException e) {
            throw new PersistenceException("Error while retrieving inputstream from parameter value.", (Throwable)e);
        }
        Resource result = parentResource.getChild(name);
        if (result != null) {
            ModifiableValueMap vm = (ModifiableValueMap)result.adaptTo(ModifiableValueMap.class);
            if (vm == null) {
                throw new PersistenceException("Resource at " + parentResource.getPath() + '/' + name + " is not modifiable.");
            }
            vm.putAll(props);
        } else {
            result = parentResource.getResourceResolver().create(parentResource, name, props);
        }
        for (String key : props.keySet()) {
            changes.add(Modification.onModified(result.getPath() + '/' + key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChunk(Resource resParent, Node res, RequestProperty prop, RequestParameter value, List<Modification> changes) throws RepositoryException {
        block23: {
            try {
                NodeIterator itr;
                long chunkOffset = prop.getChunk().getOffset();
                if (chunkOffset == 0L) {
                    NodeIterator itr2 = res.getNodes("chunk*");
                    if (itr2.hasNext()) {
                        throw new RepositoryException("Chunk upload already in progress at {" + res.getPath() + "}");
                    }
                    res.addMixin("sling:chunks");
                    changes.add(Modification.onModified(res.setProperty("sling:length", 0L).getPath()));
                    if (!res.hasProperty(JCR_DATA)) {
                        res.setProperty(JCR_DATA, (InputStream)new ByteArrayInputStream("".getBytes()));
                    }
                }
                if (!res.hasProperty("sling:length")) {
                    throw new RepositoryException("no chunk upload found at {" + res.getPath() + "}");
                }
                long currentLength = res.getProperty("sling:length").getLong();
                long totalLength = prop.getChunk().getLength();
                if (chunkOffset != currentLength) {
                    throw new RepositoryException("Chunk's offset {" + chunkOffset + "} doesn't match expected offset {" + res.getProperty("sling:length").getLong() + "}");
                }
                if (totalLength != 0L) {
                    if (res.hasProperty("sling:fileLength")) {
                        long expectedLength = res.getProperty("sling:fileLength").getLong();
                        if (totalLength != expectedLength) {
                            throw new RepositoryException("File length {" + totalLength + "} doesn't match expected length {" + expectedLength + "}");
                        }
                    } else {
                        res.setProperty("sling:fileLength", totalLength);
                    }
                }
                if ((itr = res.getNodes("chunk_" + String.valueOf(chunkOffset) + "*")).hasNext()) {
                    throw new RepositoryException("Chunk already present at {" + itr.nextNode().getPath() + "}");
                }
                String nodeName = "chunk_" + String.valueOf(chunkOffset) + "_" + String.valueOf(chunkOffset + value.getSize() - 1L);
                if (totalLength == currentLength + value.getSize() || prop.getChunk().isCompleted()) {
                    File file = null;
                    InputStream fileIns = null;
                    try {
                        file = this.mergeChunks(res, value.getInputStream());
                        fileIns = new FileInputStream(file);
                        changes.add(Modification.onModified(res.setProperty(JCR_DATA, fileIns).getPath()));
                        NodeIterator nodeItr = res.getNodes("chunk*");
                        while (nodeItr.hasNext()) {
                            Node nodeRange = nodeItr.nextNode();
                            changes.add(Modification.onDeleted(nodeRange.getPath()));
                            nodeRange.remove();
                        }
                        if (res.hasProperty("sling:fileLength")) {
                            Property expLenProp = res.getProperty("sling:fileLength");
                            changes.add(Modification.onDeleted(expLenProp.getPath()));
                            expLenProp.remove();
                        }
                        if (res.hasProperty("sling:length")) {
                            Property currLenProp = res.getProperty("sling:length");
                            changes.add(Modification.onDeleted(currLenProp.getPath()));
                            currLenProp.remove();
                        }
                        res.removeMixin("sling:chunks");
                        break block23;
                    }
                    finally {
                        try {
                            fileIns.close();
                            file.delete();
                        }
                        catch (IOException ign) {}
                    }
                }
                Node rangeNode = res.addNode(nodeName, "sling:chunk");
                changes.add(Modification.onCreated(rangeNode.getPath()));
                changes.add(Modification.onModified(rangeNode.setProperty(JCR_DATA, value.getInputStream()).getPath()));
                changes.add(Modification.onModified(rangeNode.setProperty("sling:offset", chunkOffset).getPath()));
                changes.add(Modification.onModified(res.setProperty("sling:length", currentLength + value.getSize()).getPath()));
            }
            catch (IOException e) {
                throw new RepositoryException("Error while retrieving inputstream from parameter value.", (Throwable)e);
            }
        }
    }

    private File mergeChunks(Node parentNode, InputStream lastChunkStream) throws PersistenceException, RepositoryException {
        FileOutputStream out = null;
        SequenceInputStream mergeStrm = null;
        File file = null;
        try {
            file = File.createTempFile("tmp-", "-mergechunk");
            out = new FileOutputStream(file);
            String startPattern = "chunk_0_*";
            NodeIterator nodeItr = parentNode.getNodes(startPattern);
            LinkedHashSet<InputStream> inpStrmSet = new LinkedHashSet<InputStream>();
            while (nodeItr.hasNext()) {
                if (nodeItr.getSize() > 1L) {
                    throw new RepositoryException("more than one node found for pattern: " + startPattern);
                }
                Node rangeNode = nodeItr.nextNode();
                inpStrmSet.add(rangeNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary().getStream());
                this.log.debug("added chunk {} to merge stream", (Object)rangeNode.getName());
                String[] indexBounds = rangeNode.getName().substring("chunk_".length()).split("_");
                startPattern = "chunk_" + String.valueOf(Long.valueOf(indexBounds[1]) + 1L) + "_*";
                nodeItr = parentNode.getNodes(startPattern);
            }
            inpStrmSet.add(lastChunkStream);
            mergeStrm = new SequenceInputStream(Collections.enumeration(inpStrmSet));
            IOUtils.copyLarge((InputStream)mergeStrm, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw new PersistenceException("excepiton occured", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(mergeStrm);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)mergeStrm);
        return file;
    }

    public void deleteChunks(Node node) throws RepositoryException {
        Node chunkParent = null;
        Node jcrContentNode = null;
        if (this.hasChunks(node)) {
            chunkParent = node;
        } else if (node.hasNode(JCR_CONTENT) && this.hasChunks(jcrContentNode = node.getNode(JCR_CONTENT))) {
            chunkParent = jcrContentNode;
        }
        if (chunkParent != null) {
            NodeIterator nodeItr = chunkParent.getNodes("chunk*");
            while (nodeItr.hasNext()) {
                Node rangeNode = nodeItr.nextNode();
                rangeNode.remove();
            }
            if (chunkParent.hasProperty("sling:fileLength")) {
                chunkParent.getProperty("sling:fileLength").remove();
            }
            if (chunkParent.hasProperty("sling:length")) {
                chunkParent.getProperty("sling:length").remove();
            }
            chunkParent.removeMixin("sling:chunks");
        }
    }

    public Node getLastChunk(Node node) throws RepositoryException {
        Node chunkParent = null;
        Node jcrContentNode = null;
        if (this.hasChunks(node)) {
            chunkParent = node;
        } else if (node.hasNode(JCR_CONTENT) && this.hasChunks(jcrContentNode = node.getNode(JCR_CONTENT))) {
            chunkParent = jcrContentNode;
        }
        if (chunkParent == null) {
            return null;
        }
        NodeIterator nodeItr = chunkParent.getNodes("chunk_*");
        Node chunkNode = null;
        long lastChunkStartIndex = -1L;
        while (nodeItr.hasNext()) {
            Node currentNode = nodeItr.nextNode();
            String[] indexBounds = currentNode.getName().substring("chunk_".length()).split("_");
            long chunkStartIndex = Long.valueOf(indexBounds[0]);
            if (chunkStartIndex <= lastChunkStartIndex) continue;
            chunkNode = currentNode;
            lastChunkStartIndex = chunkStartIndex;
        }
        return chunkNode;
    }

    private boolean hasChunks(Node node) throws RepositoryException {
        for (NodeType nodeType : node.getMixinNodeTypes()) {
            if (!nodeType.getName().equals("sling:chunks")) continue;
            return true;
        }
        return false;
    }

    public void setFile(Resource parent, RequestProperty prop, List<Modification> changes) throws RepositoryException, PersistenceException {
        for (RequestParameter value : prop.getValues()) {
            Node node;
            int idx;
            if (value.isFormField() || value.getSize() <= 0L) continue;
            String name = prop.getName();
            if (name.equals("*")) {
                name = value.getFileName();
                name = name.substring(name.lastIndexOf(47) + 1);
                name = name.substring(name.lastIndexOf(92) + 1);
            }
            name = Text.escapeIllegalJcrChars(name);
            String contentType = value.getContentType();
            if (contentType != null && (idx = contentType.indexOf(59)) > 0) {
                contentType = contentType.substring(0, idx);
            }
            if (contentType == null || contentType.equals(MT_APP_OCTET)) {
                ServletContext ctx = this.servletContext;
                if (ctx != null) {
                    contentType = ctx.getMimeType(value.getFileName());
                }
                if (contentType == null || contentType.equals(MT_APP_OCTET)) {
                    contentType = MT_APP_OCTET;
                }
            }
            if ((node = (Node)parent.adaptTo(Node.class)) == null) {
                this.setFile(parent, prop, value, changes, name, contentType);
                continue;
            }
            this.setFile(parent, node, prop, value, changes, name, contentType);
        }
    }

    private Resource getOrCreateChildResource(Resource parent, String name, String typeHint, List<Modification> changes) throws PersistenceException, RepositoryException {
        Resource result = parent.getChild(name);
        if (result != null) {
            Node existing = (Node)result.adaptTo(Node.class);
            if (existing != null && !existing.isNodeType(typeHint)) {
                existing.remove();
                result = this.createWithChanges(parent, name, typeHint, changes);
            }
        } else {
            result = this.createWithChanges(parent, name, typeHint, changes);
        }
        return result;
    }

    private Resource createWithChanges(Resource parent, String name, String typeHint, List<Modification> changes) throws PersistenceException {
        HashMap<String, String> properties = null;
        if (typeHint != null) {
            properties = new HashMap<String, String>();
            if (parent.adaptTo(Node.class) != null) {
                properties.put("jcr:primaryType", typeHint);
            } else {
                properties.put("sling:resourceType", typeHint);
            }
        }
        Resource result = parent.getResourceResolver().create(parent, name, properties);
        changes.add(Modification.onCreated(result.getPath()));
        return result;
    }
}

