/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.AbstractPostOperation;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;

public class CheckinOperation
extends AbstractPostOperation {
    @Override
    protected void doRun(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws RepositoryException {
        Iterator<Resource> res = this.getApplyToResources(request);
        if (res == null) {
            Resource resource = request.getResource();
            Node node = (Node)resource.adaptTo(Node.class);
            if (node == null) {
                response.setStatus(404, "Missing source " + resource + " for checkout");
                return;
            }
            node.checkin();
            changes.add(Modification.onCheckin(resource.getPath()));
        } else {
            while (res.hasNext()) {
                Resource resource = res.next();
                Node node = (Node)resource.adaptTo(Node.class);
                if (node == null) continue;
                node.checkin();
                changes.add(Modification.onCheckin(resource.getPath()));
            }
        }
    }

    @Override
    protected boolean isSkipCheckin(SlingHttpServletRequest request) {
        return false;
    }
}

