/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.AbstractPostOperation;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;

public class RestoreOperation
extends AbstractPostOperation {
    @Override
    protected void doRun(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws RepositoryException {
        String version = request.getParameter(":version");
        if (version == null || version.length() == 0) {
            throw new IllegalArgumentException("Unable to process restore. Missing version");
        }
        String removeString = request.getParameter(":removeExisting");
        boolean removeExisting = Boolean.parseBoolean(removeString);
        Iterator<Resource> res = this.getApplyToResources(request);
        if (res == null) {
            Resource resource = request.getResource();
            Node node = (Node)resource.adaptTo(Node.class);
            if (node == null) {
                response.setStatus(404, "Missing source " + resource + " for restore");
                return;
            }
            this.restore(node, version, removeExisting);
            changes.add(Modification.onRestore(resource.getPath(), version));
        } else {
            while (res.hasNext()) {
                Resource resource = res.next();
                Node node = (Node)resource.adaptTo(Node.class);
                if (node == null) continue;
                this.restore(node, version, removeExisting);
                changes.add(Modification.onRestore(resource.getPath(), version));
            }
        }
    }

    private void restore(Node node, String versionSpecifier, boolean removeExisting) throws RepositoryException {
        Version version;
        VersionManager vm = node.getSession().getWorkspace().getVersionManager();
        VersionHistory history = vm.getVersionHistory(node.getPath());
        if (history.hasVersionLabel(versionSpecifier)) {
            version = history.getVersionByLabel(versionSpecifier);
        } else if (history.hasNode(versionSpecifier)) {
            version = history.getVersion(versionSpecifier);
        } else {
            throw new IllegalArgumentException("Unable to process restore. Invalid version: " + versionSpecifier);
        }
        vm.restore(version, removeExisting);
    }
}

