/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.lang.reflect.Method;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceParser {
    private final Session session;
    private static final Logger logger = LoggerFactory.getLogger(ReferenceParser.class);

    public ReferenceParser(Session session) {
        this.session = session;
    }

    public Value parse(String value, ValueFactory factory, boolean weak) throws RepositoryException {
        Node n = this.parse(value);
        if (n == null) {
            return null;
        }
        return this.createReferenceValue(n, factory, weak);
    }

    public Value[] parse(String[] values, ValueFactory factory, boolean weak) throws RepositoryException {
        Value[] ret = new Value[values.length];
        for (int i = 0; i < values.length; ++i) {
            Node n = this.parse(values[i]);
            if (n == null) {
                return null;
            }
            ret[i] = this.createReferenceValue(n, factory, weak);
        }
        return ret;
    }

    private Value createReferenceValue(Node node, ValueFactory factory, boolean weak) throws RepositoryException {
        if (weak) {
            try {
                Method m = factory.getClass().getMethod("createValue", Node.class, Boolean.TYPE);
                return (Value)m.invoke((Object)factory, node, true);
            }
            catch (NoSuchMethodException e) {
                logger.warn("A WeakReference type hint was received, but JCR 2 isn't available. Falling back to Reference type.");
                return factory.createValue(node);
            }
            catch (Exception e) {
                logger.error("Unable to create WeakReference Value.", (Throwable)e);
                return null;
            }
        }
        return factory.createValue(node);
    }

    private Node parse(String value) throws RepositoryException {
        try {
            if (this.session.itemExists(value)) {
                return (Node)this.session.getItem(value);
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        try {
            return this.session.getNodeByUUID(value);
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }
}

