/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.List;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.operations.AbstractCopyMoveOperation;

public class MoveOperation
extends AbstractCopyMoveOperation {
    @Override
    protected String getOperationName() {
        return "move";
    }

    @Override
    protected Item execute(List<Modification> changes, Item source, String destParent, String destName, VersioningConfiguration versioningConfiguration) throws RepositoryException {
        if (destName == null) {
            destName = source.getName();
        }
        String sourcePath = source.getPath();
        if (destParent.equals("/")) {
            destParent = "";
        }
        String destPath = destParent + "/" + destName;
        Session session = source.getSession();
        this.checkoutIfNecessary(source.getParent(), changes, versioningConfiguration);
        if (session.itemExists(destPath)) {
            session.getItem(destPath).remove();
        }
        session.move(sourcePath, destPath);
        changes.add(Modification.onMoved(sourcePath, destPath));
        return session.getItem(destPath);
    }
}

