/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.servlets.post.AbstractPostResponse;

public class JSONResponse
extends AbstractPostResponse {
    public static final String RESPONSE_CONTENT_TYPE = "application/json";
    static final String PROP_TYPE = "type";
    static final String PROP_ARGUMENT = "argument";
    static final String RESPONSE_CHARSET = "UTF-8";
    private static final String PROP_CHANGES = "changes";
    private Map<String, Object> json = new HashMap<String, Object>();
    private List<Map<String, Object>> changes = new ArrayList<Map<String, Object>>();
    private Throwable error;

    @Override
    public void onChange(String type, String ... arguments) {
        HashMap<String, Object> change = new HashMap<String, Object>();
        change.put(PROP_TYPE, type);
        if (arguments.length > 1) {
            change.put(PROP_ARGUMENT, Arrays.asList(arguments));
        } else if (arguments.length == 1) {
            change.put(PROP_ARGUMENT, arguments[0]);
        }
        this.changes.add(change);
    }

    @Override
    public void setError(Throwable error) {
        this.error = error;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public void setProperty(String name, Object value) {
        this.json.put(name, value);
    }

    @Override
    public Object getProperty(String name) {
        return PROP_CHANGES.equals(name) ? this.getJson().getJsonArray(PROP_CHANGES) : ("error".equals(name) && this.error != null ? this.getJson().get((Object)"error") : this.json.get(name));
    }

    @Override
    protected void doSend(HttpServletResponse response) throws IOException {
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setCharacterEncoding(RESPONSE_CHARSET);
        Json.createGenerator((Writer)response.getWriter()).write((JsonValue)this.getJson()).close();
    }

    JsonObject getJson() {
        JsonObjectBuilder jsonBuilder = Json.createObjectBuilder();
        for (Map.Entry<String, Object> entry : this.json.entrySet()) {
            if (entry.getValue() != null) {
                jsonBuilder.add(entry.getKey(), entry.getValue().toString());
                continue;
            }
            jsonBuilder.addNull(entry.getKey());
        }
        if (this.error != null) {
            jsonBuilder.add("error", Json.createObjectBuilder().add("class", this.error.getClass().getName()).add("message", this.error.getMessage()));
        }
        JsonArrayBuilder changesBuilder = Json.createArrayBuilder();
        for (Map<String, Object> entry : this.changes) {
            JsonObjectBuilder entryBuilder = Json.createObjectBuilder();
            entryBuilder.add(PROP_TYPE, (String)entry.get(PROP_TYPE));
            Object arguments = entry.get(PROP_ARGUMENT);
            if (arguments != null) {
                if (arguments instanceof List) {
                    JsonArrayBuilder argumentsBuilder = Json.createArrayBuilder();
                    for (String argument : (List)arguments) {
                        argumentsBuilder.add(argument);
                    }
                    entryBuilder.add(PROP_ARGUMENT, argumentsBuilder);
                } else {
                    entryBuilder.add(PROP_ARGUMENT, (String)arguments);
                }
            }
            changesBuilder.add(entryBuilder);
        }
        jsonBuilder.add(PROP_CHANGES, changesBuilder);
        return jsonBuilder.build();
    }

    public class JSONResponseException
    extends RuntimeException {
        public JSONResponseException(String message, Throwable exception) {
            super(message, exception);
        }

        public JSONResponseException(Throwable e) {
            super("Error building JSON response", e);
        }
    }
}

