/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.helper.DateParser;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.apache.sling.servlets.post.impl.helper.SlingFileUploadHandler;
import org.apache.sling.servlets.post.impl.helper.SlingPropertyValueHandler;
import org.apache.sling.servlets.post.impl.operations.AbstractCreateOperation;

public class ModifyOperation
extends AbstractCreateOperation {
    private DateParser dateParser = new DateParser();
    private final SlingFileUploadHandler uploadHandler = new SlingFileUploadHandler();

    public void setServletContext(ServletContext servletContext) {
        this.uploadHandler.setServletContext(servletContext);
    }

    public void setDateParser(DateParser dateParser) {
        this.dateParser = dateParser;
    }

    @Override
    protected void doRun(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws PersistenceException {
        Map<String, RequestProperty> reqProperties = this.collectContent(request, response);
        VersioningConfiguration versioningConfiguration = this.getVersioningConfiguration(request);
        this.processCreate(request.getResourceResolver(), reqProperties, response, changes, versioningConfiguration);
        this.processMoves(request.getResourceResolver(), reqProperties, changes, versioningConfiguration);
        this.processCopies(request.getResourceResolver(), reqProperties, changes, versioningConfiguration);
        this.processDeletes(request.getResourceResolver(), reqProperties, changes, versioningConfiguration);
        this.writeContent(request.getResourceResolver(), reqProperties, changes, versioningConfiguration);
        Resource newResource = request.getResourceResolver().getResource(response.getPath());
        this.jcrSsupport.orderNode(request, newResource, changes);
    }

    @Override
    protected String getResourcePath(SlingHttpServletRequest request) {
        String suffix;
        StringBuilder rootPathBuf = new StringBuilder();
        Resource currentResource = request.getResource();
        if (ResourceUtil.isSyntheticResource((Resource)currentResource)) {
            suffix = currentResource.getPath();
        } else {
            int dotPos;
            suffix = request.getRequestPathInfo().getSuffix();
            if (suffix != null && (dotPos = suffix.indexOf(46)) > 0) {
                suffix = suffix.substring(0, dotPos);
            }
            rootPathBuf.append(currentResource.getPath());
        }
        boolean doGenerateName = false;
        if (suffix != null) {
            if (suffix.endsWith("/")) {
                suffix = suffix.substring(0, suffix.length() - "/".length());
                doGenerateName = true;
            } else if (suffix.endsWith("/*")) {
                suffix = suffix.substring(0, suffix.length() - "/*".length());
                doGenerateName = true;
            }
            rootPathBuf.append(suffix);
        }
        String path = rootPathBuf.toString();
        if (doGenerateName) {
            try {
                path = this.generateName(request, path);
            }
            catch (PersistenceException re) {
                throw new SlingException("Failed to generate name", (Throwable)re);
            }
        }
        return path;
    }

    private void processMoves(ResourceResolver resolver, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PersistenceException {
        for (RequestProperty property : reqProperties.values()) {
            if (!property.hasRepositoryMoveSource()) continue;
            this.processMovesCopiesInternal(property, true, resolver, reqProperties, changes, versioningConfiguration);
        }
    }

    private void processCopies(ResourceResolver resolver, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PersistenceException {
        for (RequestProperty property : reqProperties.values()) {
            if (!property.hasRepositoryCopySource()) continue;
            this.processMovesCopiesInternal(property, false, resolver, reqProperties, changes, versioningConfiguration);
        }
    }

    private void processMovesCopiesInternal(RequestProperty property, boolean isMove, ResourceResolver resolver, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PersistenceException {
        String propPath = property.getPath();
        String source = property.getRepositorySource();
        if (resolver.getResource(source) != null) {
            Resource parent;
            if (resolver.getResource(propPath) != null) {
                parent = resolver.getResource(propPath).getParent();
                this.jcrSsupport.checkoutIfNecessary(parent, changes, versioningConfiguration);
                resolver.delete(resolver.getResource(propPath));
                changes.add(Modification.onDeleted(propPath));
            } else {
                parent = this.deepGetOrCreateResource(resolver, property.getParentPath(), reqProperties, changes, versioningConfiguration);
                this.jcrSsupport.checkoutIfNecessary(parent, changes, versioningConfiguration);
            }
            Resource sourceRsrc = resolver.getResource(source);
            Object sourceItem = this.jcrSsupport.getItem(sourceRsrc);
            Object destItem = this.jcrSsupport.getItem(resolver.getResource(property.getParentPath()));
            if (sourceItem != null && destItem != null) {
                if (this.jcrSsupport.isNode(sourceRsrc)) {
                    if (isMove) {
                        this.jcrSsupport.checkoutIfNecessary(sourceRsrc.getParent(), changes, versioningConfiguration);
                        this.jcrSsupport.move(sourceItem, destItem, ResourceUtil.getName((String)propPath));
                    } else {
                        this.jcrSsupport.checkoutIfNecessary(resolver.getResource(property.getParentPath()), changes, versioningConfiguration);
                        this.jcrSsupport.copy(sourceItem, destItem, property.getName());
                    }
                } else {
                    this.jcrSsupport.checkoutIfNecessary(resolver.getResource(property.getParentPath()), changes, versioningConfiguration);
                    this.jcrSsupport.copy(sourceItem, destItem, ResourceUtil.getName((String)source));
                    if (isMove) {
                        this.jcrSsupport.checkoutIfNecessary(sourceRsrc.getParent(), changes, versioningConfiguration);
                        resolver.delete(sourceRsrc);
                    }
                }
            }
            property.setDelete(false);
            if (isMove) {
                changes.add(Modification.onMoved(source, propPath));
            } else {
                changes.add(Modification.onCopied(source, propPath));
            }
        }
    }

    private void processDeletes(ResourceResolver resolver, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PersistenceException {
        for (RequestProperty property : reqProperties.values()) {
            Resource parent;
            if (!property.isDelete() || (parent = resolver.getResource(property.getParentPath())) == null) continue;
            this.jcrSsupport.checkoutIfNecessary(parent, changes, versioningConfiguration);
            ValueMap vm = (ValueMap)parent.adaptTo(ModifiableValueMap.class);
            if (vm == null) {
                throw new PersistenceException("Resource '" + parent.getPath() + "' is not modifiable.");
            }
            if (vm.containsKey((Object)property.getName())) {
                if ("jcr:mixinTypes".equals(property.getName())) {
                    vm.put((Object)"jcr:mixinTypes", (Object)new String[0]);
                } else {
                    vm.remove((Object)property.getName());
                }
            } else {
                Resource childRsrc = resolver.getResource(parent.getPath() + '/' + property.getName());
                if (childRsrc != null) {
                    resolver.delete(childRsrc);
                }
            }
            changes.add(Modification.onDeleted(property.getPath()));
        }
    }

    private void writeContent(ResourceResolver resolver, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PersistenceException {
        SlingPropertyValueHandler propHandler = new SlingPropertyValueHandler(this.dateParser, this.jcrSsupport, changes);
        for (RequestProperty prop : reqProperties.values()) {
            if (!prop.hasValues()) continue;
            Resource parent = this.deepGetOrCreateResource(resolver, prop.getParentPath(), reqProperties, changes, versioningConfiguration);
            this.jcrSsupport.checkoutIfNecessary(parent, changes, versioningConfiguration);
            if (prop.getName().equals("jcr:primaryType") || prop.getName().equals("jcr:mixinTypes")) continue;
            if (prop.isFileUpload()) {
                this.uploadHandler.setFile(parent, prop, changes);
                continue;
            }
            propHandler.setProperty(parent, prop);
        }
    }
}

