/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostOperation;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.apache.sling.servlets.post.impl.helper.HtmlResponseProxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(specVersion="1.1", metatype=false)
public class PostOperationProxyProvider
implements ServiceListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String REFERENCE_FILTER = "(objectClass=org.apache.sling.servlets.post.SlingPostOperation)";
    private final Map<ServiceReference, ServiceRegistration> proxies = new IdentityHashMap<ServiceReference, ServiceRegistration>();
    private BundleContext bundleContext;

    @Activate
    private void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        try {
            bundleContext.addServiceListener((ServiceListener)this, REFERENCE_FILTER);
            ServiceReference[] serviceReferences = bundleContext.getServiceReferences("org.apache.sling.servlets.post.SlingPostOperation", null);
            if (serviceReferences != null) {
                for (ServiceReference serviceReference : serviceReferences) {
                    this.register(serviceReference);
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    private void deactivate() {
        ServiceReference[] serviceReferences;
        this.bundleContext.removeServiceListener((ServiceListener)this);
        Map<ServiceReference, ServiceRegistration> map = this.proxies;
        synchronized (map) {
            serviceReferences = this.proxies.keySet().toArray(new ServiceReference[this.proxies.size()]);
        }
        for (ServiceReference serviceReference : serviceReferences) {
            this.unregister(serviceReference);
        }
        this.bundleContext = null;
    }

    public void serviceChanged(ServiceEvent event) {
        if (this.bundleContext == null) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                this.register(event.getServiceReference());
                break;
            }
            case 2: {
                this.update(event.getServiceReference());
                break;
            }
            case 4: {
                this.unregister(event.getServiceReference());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(ServiceReference serviceReference) {
        SlingPostOperation service = (SlingPostOperation)this.bundleContext.getService(serviceReference);
        PostOperationProxy proxy = new PostOperationProxy(service);
        BundleContext bundleContext = serviceReference.getBundle().getBundleContext();
        Dictionary<String, Object> props = this.copyServiceProperties(serviceReference);
        ServiceRegistration reg = bundleContext.registerService("org.apache.sling.servlets.post.PostOperation", (Object)proxy, props);
        this.log.debug("Registering {}", (Object)proxy);
        Map<ServiceReference, ServiceRegistration> map = this.proxies;
        synchronized (map) {
            this.proxies.put(serviceReference, reg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(ServiceReference serviceReference) {
        ServiceRegistration proxyRegistration;
        Map<ServiceReference, ServiceRegistration> map = this.proxies;
        synchronized (map) {
            proxyRegistration = this.proxies.get(serviceReference);
        }
        if (proxyRegistration != null) {
            this.log.debug("Updating {}", (Object)proxyRegistration);
            proxyRegistration.setProperties(this.copyServiceProperties(serviceReference));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(ServiceReference serviceReference) {
        ServiceRegistration proxyRegistration;
        Map<ServiceReference, ServiceRegistration> map = this.proxies;
        synchronized (map) {
            proxyRegistration = this.proxies.remove(serviceReference);
        }
        if (proxyRegistration != null) {
            this.log.debug("Unregistering {}", (Object)proxyRegistration);
            this.bundleContext.ungetService(serviceReference);
            proxyRegistration.unregister();
        }
    }

    private Dictionary<String, Object> copyServiceProperties(ServiceReference serviceReference) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        for (String key : serviceReference.getPropertyKeys()) {
            ((Dictionary)props).put(key, serviceReference.getProperty(key));
        }
        ((Dictionary)props).put("sling.post.operation", serviceReference.getProperty("sling.post.operation"));
        ((Dictionary)props).put("service.description", "Proxy for " + serviceReference);
        return props;
    }

    private class PostOperationProxy
    implements PostOperation {
        private final SlingPostOperation delegatee;

        PostOperationProxy(SlingPostOperation delegatee) {
            this.delegatee = delegatee;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " for " + this.delegatee.getClass().getName();
        }

        public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
            HtmlResponseProxy apiResponse = new HtmlResponseProxy(response);
            this.delegatee.run(request, apiResponse, processors);
        }
    }
}

